/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.ws;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Resources;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.issue.index.IssueIndex;
import org.sonar.server.issue.index.IssueQuery;
import org.sonar.server.issue.ws.IssuesWsAction;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Issues;

public class TagsAction
implements IssuesWsAction {
    private static final String PARAM_ORGANIZATION = "organization";
    private static final String PARAM_PROJECT = "project";
    private final IssueIndex issueIndex;
    private final DbClient dbClient;
    private final ComponentFinder componentFinder;

    public TagsAction(IssueIndex issueIndex, DbClient dbClient, ComponentFinder componentFinder) {
        this.issueIndex = issueIndex;
        this.dbClient = dbClient;
        this.componentFinder = componentFinder;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("tags").setHandler((RequestHandler)this).setSince("5.1").setDescription("List tags matching a given query").setResponseExample(Resources.getResource(this.getClass(), (String)"tags-example.json")).setChangelog(new Change[]{new Change("7.4", "Result doesn't include rules tags anymore")});
        action.createSearchQuery("misra", new String[]{"tags"});
        action.createPageSize(10, 100);
        action.createParam(PARAM_ORGANIZATION).setDescription("Organization key").setRequired(false).setInternal(true).setExampleValue((Object)"my-org").setSince("6.4");
        action.createParam(PARAM_PROJECT).setDescription("Project key").setRequired(false).setExampleValue((Object)"my_project").setSince("7.4");
    }

    public void handle(Request request, Response response) throws Exception {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Optional<OrganizationDto> organization = this.getOrganization(dbSession, request.param(PARAM_ORGANIZATION));
            Optional<ComponentDto> project = this.getProject(dbSession, organization, request.param(PARAM_PROJECT));
            List<String> tags = this.searchTags(organization, project, request);
            Issues.TagsResponse.Builder tagsResponseBuilder = Issues.TagsResponse.newBuilder();
            tags.forEach(arg_0 -> ((Issues.TagsResponse.Builder)tagsResponseBuilder).addTags(arg_0));
            WsUtils.writeProtobuf((Message)tagsResponseBuilder.build(), request, response);
        }
    }

    private Optional<OrganizationDto> getOrganization(DbSession dbSession, @Nullable String organizationKey) {
        return organizationKey == null ? Optional.empty() : Optional.of(WsUtils.checkFoundWithOptional(this.dbClient.organizationDao().selectByKey(dbSession, organizationKey), "No organization with key '%s'", organizationKey));
    }

    private Optional<ComponentDto> getProject(DbSession dbSession, Optional<OrganizationDto> organization, @Nullable String projectKey) {
        if (projectKey == null) {
            return Optional.empty();
        }
        ComponentDto project = this.componentFinder.getByKey(dbSession, projectKey);
        Preconditions.checkArgument((boolean)project.scope().equals("PRJ"), (String)"Component '%s' must be a project", (Object[])new Object[]{projectKey});
        organization.ifPresent(o -> Preconditions.checkArgument((boolean)project.getOrganizationUuid().equals(o.getUuid()), (String)"Project '%s' is not part of the organization '%s'", (Object[])new Object[]{projectKey, o.getKey()}));
        return Optional.of(project);
    }

    private List<String> searchTags(Optional<OrganizationDto> organization, Optional<ComponentDto> project, Request request) {
        IssueQuery.Builder issueQueryBuilder = IssueQuery.builder();
        organization.ifPresent(o -> issueQueryBuilder.organizationUuid(o.getUuid()));
        project.ifPresent(p -> {
            switch (p.qualifier()) {
                case "TRK": {
                    issueQueryBuilder.projectUuids((Collection<String>)ImmutableSet.of((Object)p.uuid()));
                    return;
                }
                case "APP": 
                case "VW": {
                    issueQueryBuilder.viewUuids((Collection<String>)ImmutableSet.of((Object)p.uuid()));
                    return;
                }
            }
            throw new IllegalArgumentException(String.format("Component of type '%s' is not supported", p.qualifier()));
        });
        return this.issueIndex.searchTags(issueQueryBuilder.build(), request.param("q"), request.mandatoryParamAsInt("ps"));
    }
}

