/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.language.ws;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Resources;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Languages;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;

public class ListAction
implements RequestHandler {
    private static final String MATCH_ALL = ".*";
    private final Languages languages;

    public ListAction(Languages languages) {
        this.languages = languages;
    }

    public void handle(Request request, Response response) throws Exception {
        String query = request.param("q");
        int pageSize = request.mandatoryParamAsInt("ps");
        try (JsonWriter json = response.newJsonWriter();){
            json.beginObject().name("languages").beginArray();
            for (Language language : this.listMatchingLanguages(query, pageSize)) {
                json.beginObject().prop("key", language.getKey()).prop("name", language.getName()).endObject();
            }
            json.endArray().endObject();
        }
    }

    void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("list").setDescription("List supported programming languages").setSince("5.1").setHandler((RequestHandler)this).setResponseExample(Resources.getResource(this.getClass(), (String)"example-list.json"));
        action.createParam("q").setDescription("A pattern to match language keys/names against").setExampleValue((Object)"java");
        action.createParam("ps").setDescription("The size of the list to return, 0 for all languages").setExampleValue((Object)"25").setDefaultValue((Object)"0");
    }

    private Collection<Language> listMatchingLanguages(@Nullable String query, int pageSize) {
        Pattern pattern = Pattern.compile(query == null ? MATCH_ALL : MATCH_ALL + Pattern.quote(query) + MATCH_ALL, 2);
        TreeMap languagesByName = Maps.newTreeMap();
        for (Language lang : this.languages.all()) {
            if (!pattern.matcher(lang.getKey()).matches() && !pattern.matcher(lang.getName()).matches()) continue;
            languagesByName.put(lang.getName(), lang);
        }
        List result = Lists.newArrayList(languagesByName.values());
        if (pageSize > 0 && pageSize < result.size()) {
            result = result.subList(0, pageSize);
        }
        return result;
    }
}

