/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.index;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.filter.Filter;
import org.elasticsearch.search.aggregations.bucket.filter.FilterAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.filter.FiltersAggregator;
import org.elasticsearch.search.aggregations.bucket.nested.Nested;
import org.elasticsearch.search.aggregations.bucket.range.RangeAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.sum.Sum;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.NestedSortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.System2;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.server.es.EsClient;
import org.sonar.server.es.EsUtils;
import org.sonar.server.es.SearchIdResult;
import org.sonar.server.es.SearchOptions;
import org.sonar.server.es.StickyFacetBuilder;
import org.sonar.server.es.newindex.DefaultIndexSettingsElement;
import org.sonar.server.measure.index.ProjectMeasuresDoc;
import org.sonar.server.measure.index.ProjectMeasuresIndexDefinition;
import org.sonar.server.measure.index.ProjectMeasuresQuery;
import org.sonar.server.measure.index.ProjectMeasuresStatistics;
import org.sonar.server.measure.index.ProjectsTextSearchQueryFactory;
import org.sonar.server.permission.index.WebAuthorizationTypeSupport;

@ServerSide
public class ProjectMeasuresIndex {
    public static final List<String> SUPPORTED_FACETS = ImmutableList.of((Object)"ncloc", (Object)"new_lines", (Object)"duplicated_lines_density", (Object)"new_duplicated_lines_density", (Object)"coverage", (Object)"new_coverage", (Object)"sqale_rating", (Object)"new_maintainability_rating", (Object)"reliability_rating", (Object)"new_reliability_rating", (Object)"security_rating", (Object)"new_security_rating", (Object[])new String[]{"alert_status", "languages", "tags"});
    private static final Double[] LINES_THRESHOLDS = new Double[]{1000.0, 10000.0, 100000.0, 500000.0};
    private static final Double[] COVERAGE_THRESHOLDS = new Double[]{30.0, 50.0, 70.0, 80.0};
    private static final Double[] DUPLICATIONS_THRESHOLDS = new Double[]{3.0, 5.0, 10.0, 20.0};
    private static final String FIELD_MEASURES_KEY = "measures.key";
    private static final String FIELD_MEASURES_VALUE = "measures.value";
    private static final String FIELD_DISTRIB_LANGUAGE = "nclocLanguageDistribution.language";
    private static final String FIELD_DISTRIB_NCLOC = "nclocLanguageDistribution.ncloc";
    private static final Map<String, FacetSetter> FACET_FACTORIES = ImmutableMap.builder().put((Object)"ncloc", (esSearch, query, facetBuilder) -> ProjectMeasuresIndex.addRangeFacet(esSearch, "ncloc", facetBuilder, LINES_THRESHOLDS)).put((Object)"new_lines", (esSearch, query, facetBuilder) -> ProjectMeasuresIndex.addRangeFacet(esSearch, "new_lines", facetBuilder, LINES_THRESHOLDS)).put((Object)"duplicated_lines_density", (esSearch, query, facetBuilder) -> ProjectMeasuresIndex.addRangeFacetIncludingNoData(esSearch, "duplicated_lines_density", facetBuilder, DUPLICATIONS_THRESHOLDS)).put((Object)"new_duplicated_lines_density", (esSearch, query, facetBuilder) -> ProjectMeasuresIndex.addRangeFacetIncludingNoData(esSearch, "new_duplicated_lines_density", facetBuilder, DUPLICATIONS_THRESHOLDS)).put((Object)"coverage", (esSearch, query, facetBuilder) -> ProjectMeasuresIndex.addRangeFacetIncludingNoData(esSearch, "coverage", facetBuilder, COVERAGE_THRESHOLDS)).put((Object)"new_coverage", (esSearch, query, facetBuilder) -> ProjectMeasuresIndex.addRangeFacetIncludingNoData(esSearch, "new_coverage", facetBuilder, COVERAGE_THRESHOLDS)).put((Object)"sqale_rating", (esSearch, query, facetBuilder) -> ProjectMeasuresIndex.addRatingFacet(esSearch, "sqale_rating", facetBuilder)).put((Object)"new_maintainability_rating", (esSearch, query, facetBuilder) -> ProjectMeasuresIndex.addRatingFacet(esSearch, "new_maintainability_rating", facetBuilder)).put((Object)"reliability_rating", (esSearch, query, facetBuilder) -> ProjectMeasuresIndex.addRatingFacet(esSearch, "reliability_rating", facetBuilder)).put((Object)"new_reliability_rating", (esSearch, query, facetBuilder) -> ProjectMeasuresIndex.addRatingFacet(esSearch, "new_reliability_rating", facetBuilder)).put((Object)"security_rating", (esSearch, query, facetBuilder) -> ProjectMeasuresIndex.addRatingFacet(esSearch, "security_rating", facetBuilder)).put((Object)"new_security_rating", (esSearch, query, facetBuilder) -> ProjectMeasuresIndex.addRatingFacet(esSearch, "new_security_rating", facetBuilder)).put((Object)"alert_status", (esSearch, query, facetBuilder) -> esSearch.addAggregation((AggregationBuilder)ProjectMeasuresIndex.createStickyFacet("alert_status", facetBuilder, ProjectMeasuresIndex.createQualityGateFacet()))).put((Object)"languages", ProjectMeasuresIndex::addLanguagesFacet).put((Object)"tags", ProjectMeasuresIndex::addTagsFacet).build();
    private final EsClient client;
    private final WebAuthorizationTypeSupport authorizationTypeSupport;
    private final System2 system2;

    public ProjectMeasuresIndex(EsClient client, WebAuthorizationTypeSupport authorizationTypeSupport, System2 system2) {
        this.client = client;
        this.authorizationTypeSupport = authorizationTypeSupport;
        this.system2 = system2;
    }

    public SearchIdResult<String> search(ProjectMeasuresQuery query, SearchOptions searchOptions) {
        SearchRequestBuilder requestBuilder = this.client.prepareSearch(ProjectMeasuresIndexDefinition.TYPE_PROJECT_MEASURES.getMainType()).setFetchSource(false).setFrom(searchOptions.getOffset()).setSize(searchOptions.getLimit());
        BoolQueryBuilder esFilter = QueryBuilders.boolQuery();
        Map<String, QueryBuilder> filters = this.createFilters(query);
        filters.values().forEach(arg_0 -> ((BoolQueryBuilder)esFilter).must(arg_0));
        requestBuilder.setQuery((QueryBuilder)esFilter);
        ProjectMeasuresIndex.addFacets(requestBuilder, searchOptions, filters, query);
        ProjectMeasuresIndex.addSort(query, requestBuilder);
        return new SearchIdResult((SearchResponse)requestBuilder.get(), id -> id, this.system2.getDefaultTimeZone());
    }

    public ProjectMeasuresStatistics searchTelemetryStatistics() {
        SearchRequestBuilder request = this.client.prepareSearch(ProjectMeasuresIndexDefinition.TYPE_PROJECT_MEASURES.getMainType()).setFetchSource(false).setSize(0);
        BoolQueryBuilder esFilter = QueryBuilders.boolQuery();
        request.setQuery((QueryBuilder)esFilter);
        request.addAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"languages").field("languages")).size(500).minDocCount(1L).order(BucketOrder.count((boolean)false)));
        request.addAggregation((AggregationBuilder)AggregationBuilders.nested((String)"nclocLanguageDistribution", (String)"nclocLanguageDistribution").subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"nclocLanguageDistribution_terms").field(FIELD_DISTRIB_LANGUAGE)).size(500).minDocCount(1L).order(BucketOrder.count((boolean)false)).subAggregation((AggregationBuilder)AggregationBuilders.sum((String)FIELD_DISTRIB_NCLOC).field(FIELD_DISTRIB_NCLOC))));
        request.addAggregation((AggregationBuilder)AggregationBuilders.nested((String)"ncloc", (String)"measures").subAggregation((AggregationBuilder)AggregationBuilders.filter((String)"ncloc_filter", (QueryBuilder)QueryBuilders.termQuery((String)FIELD_MEASURES_KEY, (String)"ncloc")).subAggregation((AggregationBuilder)AggregationBuilders.sum((String)"ncloc_filter_sum").field(FIELD_MEASURES_VALUE))));
        ProjectMeasuresStatistics.Builder statistics = ProjectMeasuresStatistics.builder();
        SearchResponse response = (SearchResponse)request.get();
        statistics.setProjectCount(response.getHits().getTotalHits());
        Stream.of("ncloc").map(metric -> (Nested)response.getAggregations().get(metric)).map(nested -> (Filter)nested.getAggregations().get(nested.getName() + "_filter")).map(filter -> (Sum)filter.getAggregations().get(filter.getName() + "_sum")).forEach(sum -> {
            String metric = sum.getName().replace("_filter_sum", "");
            long value = Math.round(sum.getValue());
            statistics.setSum(metric, value);
        });
        statistics.setProjectCountByLanguage(EsUtils.termsToMap((Terms)((Terms)response.getAggregations().get("languages"))));
        Function<Terms.Bucket, Long> bucketToNcloc = bucket -> Math.round(((Sum)bucket.getAggregations().get(FIELD_DISTRIB_NCLOC)).getValue());
        Map nclocByLanguage = (Map)Stream.of((Nested)response.getAggregations().get("nclocLanguageDistribution")).map(nested -> (Terms)nested.getAggregations().get(nested.getName() + "_terms")).flatMap(terms -> terms.getBuckets().stream()).collect(MoreCollectors.uniqueIndex(MultiBucketsAggregation.Bucket::getKeyAsString, bucketToNcloc));
        statistics.setNclocByLanguage(nclocByLanguage);
        return statistics.build();
    }

    private static void addSort(ProjectMeasuresQuery query, SearchRequestBuilder requestBuilder) {
        String sort = query.getSort();
        if ("name".equals(sort)) {
            requestBuilder.addSort(DefaultIndexSettingsElement.SORTABLE_ANALYZER.subField("name"), query.isAsc() ? SortOrder.ASC : SortOrder.DESC);
        } else if ("analysisDate".equals(sort)) {
            requestBuilder.addSort("analysedAt", query.isAsc() ? SortOrder.ASC : SortOrder.DESC);
        } else if ("alert_status".equals(sort)) {
            requestBuilder.addSort("qualityGateStatus", query.isAsc() ? SortOrder.ASC : SortOrder.DESC);
            requestBuilder.addSort(DefaultIndexSettingsElement.SORTABLE_ANALYZER.subField("name"), SortOrder.ASC);
        } else {
            ProjectMeasuresIndex.addMetricSort(query, requestBuilder, sort);
            requestBuilder.addSort(DefaultIndexSettingsElement.SORTABLE_ANALYZER.subField("name"), SortOrder.ASC);
        }
        requestBuilder.addSort("key", SortOrder.ASC);
    }

    private static void addMetricSort(ProjectMeasuresQuery query, SearchRequestBuilder requestBuilder, String sort) {
        requestBuilder.addSort(new FieldSortBuilder(FIELD_MEASURES_VALUE).setNestedSort(new NestedSortBuilder("measures").setFilter((QueryBuilder)QueryBuilders.termQuery((String)FIELD_MEASURES_KEY, (String)sort))).order(query.isAsc() ? SortOrder.ASC : SortOrder.DESC));
    }

    private static void addRangeFacet(SearchRequestBuilder esSearch, String metricKey, StickyFacetBuilder facetBuilder, Double ... thresholds) {
        esSearch.addAggregation((AggregationBuilder)ProjectMeasuresIndex.createStickyFacet(metricKey, facetBuilder, ProjectMeasuresIndex.createRangeFacet(metricKey, thresholds)));
    }

    private static void addRangeFacetIncludingNoData(SearchRequestBuilder esSearch, String metricKey, StickyFacetBuilder facetBuilder, Double ... thresholds) {
        esSearch.addAggregation((AggregationBuilder)ProjectMeasuresIndex.createStickyFacet(metricKey, facetBuilder, ((FilterAggregationBuilder)AggregationBuilders.filter((String)("combined_" + metricKey), (QueryBuilder)QueryBuilders.matchAllQuery()).subAggregation((AggregationBuilder)ProjectMeasuresIndex.createRangeFacet(metricKey, thresholds))).subAggregation((AggregationBuilder)ProjectMeasuresIndex.createNoDataFacet(metricKey))));
    }

    private static void addRatingFacet(SearchRequestBuilder esSearch, String metricKey, StickyFacetBuilder facetBuilder) {
        esSearch.addAggregation((AggregationBuilder)ProjectMeasuresIndex.createStickyFacet(metricKey, facetBuilder, ProjectMeasuresIndex.createRatingFacet(metricKey)));
    }

    private static void addLanguagesFacet(SearchRequestBuilder esSearch, ProjectMeasuresQuery query, StickyFacetBuilder facetBuilder) {
        esSearch.addAggregation(facetBuilder.buildStickyFacet("languages", "languages", query.getLanguages().map(Set::toArray).orElseGet(() -> new Object[0])));
    }

    private static void addTagsFacet(SearchRequestBuilder esSearch, ProjectMeasuresQuery query, StickyFacetBuilder facetBuilder) {
        esSearch.addAggregation(facetBuilder.buildStickyFacet("tags", "tags", query.getTags().map(Set::toArray).orElseGet(() -> new Object[0])));
    }

    private static void addFacets(SearchRequestBuilder esSearch, SearchOptions options, Map<String, QueryBuilder> filters, ProjectMeasuresQuery query) {
        StickyFacetBuilder facetBuilder = new StickyFacetBuilder((QueryBuilder)QueryBuilders.matchAllQuery(), filters);
        options.getFacets().stream().filter(FACET_FACTORIES::containsKey).map(FACET_FACTORIES::get).forEach(factory -> factory.addFacet(esSearch, query, facetBuilder));
    }

    private static AbstractAggregationBuilder createStickyFacet(String facetKey, StickyFacetBuilder facetBuilder, AbstractAggregationBuilder aggregationBuilder) {
        BoolQueryBuilder facetFilter = facetBuilder.getStickyFacetFilter(new String[]{facetKey});
        return AggregationBuilders.global((String)facetKey).subAggregation((AggregationBuilder)AggregationBuilders.filter((String)("facet_filter_" + facetKey), (QueryBuilder)facetFilter).subAggregation((AggregationBuilder)aggregationBuilder));
    }

    private static AbstractAggregationBuilder createRangeFacet(String metricKey, Double ... thresholds) {
        RangeAggregationBuilder rangeAgg = (RangeAggregationBuilder)AggregationBuilders.range((String)metricKey).field(FIELD_MEASURES_VALUE);
        int lastIndex = thresholds.length - 1;
        IntStream.range(0, thresholds.length).forEach(i -> {
            if (i == 0) {
                rangeAgg.addUnboundedTo(thresholds[0].doubleValue());
                rangeAgg.addRange(thresholds[0].doubleValue(), thresholds[1].doubleValue());
            } else if (i == lastIndex) {
                rangeAgg.addUnboundedFrom(thresholds[lastIndex].doubleValue());
            } else {
                rangeAgg.addRange(thresholds[i].doubleValue(), thresholds[i + 1].doubleValue());
            }
        });
        return AggregationBuilders.nested((String)("nested_" + metricKey), (String)"measures").subAggregation((AggregationBuilder)AggregationBuilders.filter((String)("filter_" + metricKey), (QueryBuilder)QueryBuilders.termsQuery((String)FIELD_MEASURES_KEY, (String[])new String[]{metricKey})).subAggregation((AggregationBuilder)rangeAgg));
    }

    private static AbstractAggregationBuilder createNoDataFacet(String metricKey) {
        return AggregationBuilders.filter((String)("no_data_" + metricKey), (QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.nestedQuery((String)"measures", (QueryBuilder)QueryBuilders.termQuery((String)FIELD_MEASURES_KEY, (String)metricKey), (ScoreMode)ScoreMode.Avg)));
    }

    private static AbstractAggregationBuilder createRatingFacet(String metricKey) {
        return AggregationBuilders.nested((String)("nested_" + metricKey), (String)"measures").subAggregation((AggregationBuilder)AggregationBuilders.filter((String)("filter_" + metricKey), (QueryBuilder)QueryBuilders.termsQuery((String)FIELD_MEASURES_KEY, (String[])new String[]{metricKey})).subAggregation((AggregationBuilder)AggregationBuilders.filters((String)metricKey, (FiltersAggregator.KeyedFilter[])new FiltersAggregator.KeyedFilter[]{new FiltersAggregator.KeyedFilter("1", (QueryBuilder)QueryBuilders.termQuery((String)FIELD_MEASURES_VALUE, (double)1.0)), new FiltersAggregator.KeyedFilter("2", (QueryBuilder)QueryBuilders.termQuery((String)FIELD_MEASURES_VALUE, (double)2.0)), new FiltersAggregator.KeyedFilter("3", (QueryBuilder)QueryBuilders.termQuery((String)FIELD_MEASURES_VALUE, (double)3.0)), new FiltersAggregator.KeyedFilter("4", (QueryBuilder)QueryBuilders.termQuery((String)FIELD_MEASURES_VALUE, (double)4.0)), new FiltersAggregator.KeyedFilter("5", (QueryBuilder)QueryBuilders.termQuery((String)FIELD_MEASURES_VALUE, (double)5.0))})));
    }

    private static AbstractAggregationBuilder createQualityGateFacet() {
        return AggregationBuilders.filters((String)"alert_status", (FiltersAggregator.KeyedFilter[])((FiltersAggregator.KeyedFilter[])ProjectMeasuresDoc.QUALITY_GATE_STATUS.entrySet().stream().map(entry -> new FiltersAggregator.KeyedFilter((String)entry.getKey(), (QueryBuilder)QueryBuilders.termQuery((String)"qualityGateStatus", entry.getValue()))).toArray(FiltersAggregator.KeyedFilter[]::new)));
    }

    private Map<String, QueryBuilder> createFilters(ProjectMeasuresQuery query) {
        HashMap<String, QueryBuilder> filters = new HashMap<String, QueryBuilder>();
        filters.put("__indexType", (QueryBuilder)QueryBuilders.termQuery((String)"indexType", (String)ProjectMeasuresIndexDefinition.TYPE_PROJECT_MEASURES.getName()));
        filters.put("__authorization", this.authorizationTypeSupport.createQueryFilter());
        ArrayListMultimap metricCriterionMultimap = ArrayListMultimap.create();
        query.getMetricCriteria().forEach(arg_0 -> ProjectMeasuresIndex.lambda$createFilters$27((Multimap)metricCriterionMultimap, arg_0));
        metricCriterionMultimap.asMap().forEach((key, value) -> {
            BoolQueryBuilder metricFilters = QueryBuilders.boolQuery();
            value.stream().map(ProjectMeasuresIndex::toQuery).forEach(arg_0 -> ((BoolQueryBuilder)metricFilters).must(arg_0));
            filters.put((String)key, (QueryBuilder)metricFilters);
        });
        query.getQualityGateStatus().ifPresent(qualityGateStatus -> {
            QueryBuilder cfr_ignored_0 = (QueryBuilder)filters.put("alert_status", (QueryBuilder)QueryBuilders.termQuery((String)"qualityGateStatus", ProjectMeasuresDoc.QUALITY_GATE_STATUS.get(qualityGateStatus.name())));
        });
        query.getProjectUuids().ifPresent(projectUuids -> {
            QueryBuilder cfr_ignored_0 = (QueryBuilder)filters.put("ids", (QueryBuilder)QueryBuilders.termsQuery((String)"_id", (Collection)projectUuids));
        });
        query.getLanguages().ifPresent(languages -> {
            QueryBuilder cfr_ignored_0 = (QueryBuilder)filters.put("languages", (QueryBuilder)QueryBuilders.termsQuery((String)"languages", (Collection)languages));
        });
        query.getOrganizationUuid().ifPresent(organizationUuid -> {
            QueryBuilder cfr_ignored_0 = (QueryBuilder)filters.put("organizationUuid", (QueryBuilder)QueryBuilders.termQuery((String)"organizationUuid", (String)organizationUuid));
        });
        query.getTags().ifPresent(tags -> {
            QueryBuilder cfr_ignored_0 = (QueryBuilder)filters.put("tags", (QueryBuilder)QueryBuilders.termsQuery((String)"tags", (Collection)tags));
        });
        query.getQueryText().map(ProjectsTextSearchQueryFactory::createQuery).ifPresent(queryBuilder -> filters.put("textQuery", (QueryBuilder)queryBuilder));
        return filters;
    }

    private static QueryBuilder toQuery(ProjectMeasuresQuery.MetricCriterion criterion) {
        if (criterion.isNoData()) {
            return QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.nestedQuery((String)"measures", (QueryBuilder)QueryBuilders.termQuery((String)FIELD_MEASURES_KEY, (String)criterion.getMetricKey()), (ScoreMode)ScoreMode.Avg));
        }
        return QueryBuilders.nestedQuery((String)"measures", (QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)FIELD_MEASURES_KEY, (String)criterion.getMetricKey())).filter(ProjectMeasuresIndex.toValueQuery(criterion)), (ScoreMode)ScoreMode.Avg);
    }

    private static QueryBuilder toValueQuery(ProjectMeasuresQuery.MetricCriterion criterion) {
        String fieldName = FIELD_MEASURES_VALUE;
        switch (criterion.getOperator()) {
            case GT: {
                return QueryBuilders.rangeQuery((String)fieldName).gt((Object)criterion.getValue());
            }
            case GTE: {
                return QueryBuilders.rangeQuery((String)fieldName).gte((Object)criterion.getValue());
            }
            case LT: {
                return QueryBuilders.rangeQuery((String)fieldName).lt((Object)criterion.getValue());
            }
            case LTE: {
                return QueryBuilders.rangeQuery((String)fieldName).lte((Object)criterion.getValue());
            }
            case EQ: {
                return QueryBuilders.termQuery((String)fieldName, (double)criterion.getValue());
            }
        }
        throw new IllegalStateException("Metric criteria non supported: " + criterion.getOperator().name());
    }

    public List<String> searchTags(@Nullable String textQuery, int size) {
        int maxPageSize = 500;
        Preconditions.checkArgument((size <= maxPageSize ? 1 : 0) != 0, (Object)("Page size must be lower than or equals to " + maxPageSize));
        if (size <= 0) {
            return Collections.emptyList();
        }
        TermsAggregationBuilder tagFacet = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"tags").field("tags")).size(size).minDocCount(1L).order(BucketOrder.key((boolean)true));
        if (textQuery != null) {
            tagFacet.includeExclude(new IncludeExclude(".*" + EsUtils.escapeSpecialRegexChars((String)textQuery) + ".*", null));
        }
        SearchRequestBuilder searchQuery = this.client.prepareSearch(ProjectMeasuresIndexDefinition.TYPE_PROJECT_MEASURES.getMainType()).setQuery(this.authorizationTypeSupport.createQueryFilter()).setFetchSource(false).setSize(0).addAggregation((AggregationBuilder)tagFacet);
        Terms aggregation = (Terms)((SearchResponse)searchQuery.get()).getAggregations().get("tags");
        return (List)aggregation.getBuckets().stream().map(MultiBucketsAggregation.Bucket::getKeyAsString).collect(MoreCollectors.toList());
    }

    private static /* synthetic */ void lambda$createFilters$27(Multimap metricCriterionMultimap, ProjectMeasuresQuery.MetricCriterion metricCriterion) {
        metricCriterionMultimap.put((Object)metricCriterion.getMetricKey(), (Object)metricCriterion);
    }

    @FunctionalInterface
    private static interface FacetSetter {
        public void addFacet(SearchRequestBuilder var1, ProjectMeasuresQuery var2, StickyFacetBuilder var3);
    }
}

