/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.index;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.measures.Metric;

public class ProjectMeasuresQuery {
    public static final String SORT_BY_NAME = "name";
    public static final String SORT_BY_LAST_ANALYSIS_DATE = "analysisDate";
    private List<MetricCriterion> metricCriteria = new ArrayList<MetricCriterion>();
    private Metric.Level qualityGateStatus;
    private String organizationUuid;
    private Set<String> projectUuids;
    private Set<String> languages;
    private Set<String> tags;
    private String sort = "name";
    private boolean asc = true;
    private String queryText;

    public ProjectMeasuresQuery addMetricCriterion(MetricCriterion metricCriterion) {
        this.metricCriteria.add(metricCriterion);
        return this;
    }

    public List<MetricCriterion> getMetricCriteria() {
        return this.metricCriteria;
    }

    public ProjectMeasuresQuery setQualityGateStatus(Metric.Level qualityGateStatus) {
        this.qualityGateStatus = Objects.requireNonNull(qualityGateStatus);
        return this;
    }

    public Optional<Metric.Level> getQualityGateStatus() {
        return Optional.ofNullable(this.qualityGateStatus);
    }

    public ProjectMeasuresQuery setOrganizationUuid(@Nullable String organizationUuid) {
        this.organizationUuid = organizationUuid;
        return this;
    }

    public Optional<String> getOrganizationUuid() {
        return Optional.ofNullable(this.organizationUuid);
    }

    public ProjectMeasuresQuery setProjectUuids(@Nullable Set<String> projectUuids) {
        this.projectUuids = projectUuids;
        return this;
    }

    public Optional<Set<String>> getProjectUuids() {
        return Optional.ofNullable(this.projectUuids);
    }

    public ProjectMeasuresQuery setLanguages(@Nullable Set<String> languages) {
        this.languages = languages;
        return this;
    }

    public Optional<Set<String>> getLanguages() {
        return Optional.ofNullable(this.languages);
    }

    public ProjectMeasuresQuery setTags(@Nullable Set<String> tags) {
        this.tags = tags;
        return this;
    }

    public Optional<Set<String>> getTags() {
        return Optional.ofNullable(this.tags);
    }

    public Optional<String> getQueryText() {
        return Optional.ofNullable(this.queryText);
    }

    public ProjectMeasuresQuery setQueryText(@Nullable String queryText) {
        this.queryText = queryText;
        return this;
    }

    public String getSort() {
        return this.sort;
    }

    public ProjectMeasuresQuery setSort(String sort) {
        this.sort = Objects.requireNonNull(sort, "Sort cannot be null");
        return this;
    }

    public boolean isAsc() {
        return this.asc;
    }

    public ProjectMeasuresQuery setAsc(boolean asc) {
        this.asc = asc;
        return this;
    }

    public static enum Operator {
        LT("<"),
        LTE("<="),
        GT(">"),
        GTE(">="),
        EQ("="),
        IN("in");

        String value;

        private Operator(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static Operator getByValue(String value) {
            return Arrays.stream(Operator.values()).filter(operator -> operator.getValue().equalsIgnoreCase(value)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Unknown operator '%s'", value)));
        }
    }

    public static class MetricCriterion {
        private final String metricKey;
        private final Operator operator;
        @Nullable
        private final Double value;

        private MetricCriterion(String metricKey, @Nullable Operator operator, @Nullable Double value) {
            this.metricKey = metricKey;
            this.operator = operator;
            this.value = value;
        }

        public String getMetricKey() {
            return this.metricKey;
        }

        public Operator getOperator() {
            this.checkDataAvailable();
            return this.operator;
        }

        public double getValue() {
            this.checkDataAvailable();
            return this.value;
        }

        public boolean isNoData() {
            return this.value == null;
        }

        public static MetricCriterion createNoData(String metricKey) {
            return new MetricCriterion(Objects.requireNonNull(metricKey), null, null);
        }

        public static MetricCriterion create(String metricKey, Operator operator, double value) {
            return new MetricCriterion(Objects.requireNonNull(metricKey), Objects.requireNonNull(operator), value);
        }

        private void checkDataAvailable() {
            Preconditions.checkState((!this.isNoData() ? 1 : 0) != 0, (String)"The criterion for metric %s has no data", (Object[])new Object[]{this.metricKey});
        }
    }
}

