/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.ws;

import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.db.measure.LiveMeasureDto;
import org.sonar.db.measure.MeasureDto;
import org.sonar.db.metric.MetricDto;
import org.sonar.server.measure.ws.MeasureValueFormatter;
import org.sonarqube.ws.Measures;

class MeasureDtoToWsMeasure {
    private MeasureDtoToWsMeasure() {
    }

    static void updateMeasureBuilder(Measures.Measure.Builder measureBuilder, MetricDto metricDto, MeasureDto measureDto) {
        Double value = measureDto.getValue();
        Double variation = measureDto.getVariation();
        MeasureDtoToWsMeasure.updateMeasureBuilder(measureBuilder, metricDto, value == null ? Double.NaN : value, measureDto.getData(), variation == null ? Double.NaN : variation);
    }

    static void updateMeasureBuilder(Measures.Measure.Builder measureBuilder, MetricDto metricDto, LiveMeasureDto measureDto) {
        Double value = measureDto.getValue();
        Double variation = measureDto.getVariation();
        MeasureDtoToWsMeasure.updateMeasureBuilder(measureBuilder, metricDto, value == null ? Double.NaN : value, measureDto.getDataAsString(), variation == null ? Double.NaN : variation);
    }

    static void updateMeasureBuilder(Measures.Measure.Builder measureBuilder, MetricDto metric, double doubleValue, @Nullable String stringValue, double variation) {
        measureBuilder.setMetric(metric.getKey());
        Double bestValue = metric.getBestValue();
        if (!Double.isNaN(doubleValue) || stringValue != null) {
            measureBuilder.setValue(MeasureValueFormatter.formatMeasureValue(doubleValue, stringValue, metric));
            Optional.ofNullable(bestValue).ifPresent(v -> measureBuilder.setBestValue(Double.compare(doubleValue, v) == 0));
        }
        Measures.PeriodValue.Builder periodBuilder = Measures.PeriodValue.newBuilder();
        if (Double.isNaN(variation)) {
            return;
        }
        Measures.PeriodValue.Builder builderForValue = periodBuilder.clear().setIndex(1).setValue(MeasureValueFormatter.formatNumericalValue(variation, metric));
        Optional.ofNullable(bestValue).ifPresent(v -> builderForValue.setBestValue(Double.compare(variation, v) == 0));
        measureBuilder.getPeriodsBuilder().addPeriodsValue(builderForValue);
    }
}

