/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.ws;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.measures.Metric;
import org.sonar.db.measure.LiveMeasureDto;
import org.sonar.db.measure.MeasureDto;
import org.sonar.db.metric.MetricDto;

public class MeasureValueFormatter {
    private static final double DELTA = 1.0E-6;

    private MeasureValueFormatter() {
    }

    @CheckForNull
    public static String formatMeasureValue(LiveMeasureDto measure, MetricDto metric) {
        Double doubleValue = measure.getValue();
        String stringValue = measure.getDataAsString();
        return MeasureValueFormatter.formatMeasureValue(doubleValue == null ? Double.NaN : doubleValue, stringValue, metric);
    }

    @CheckForNull
    static String formatMeasureValue(MeasureDto measure, MetricDto metric) {
        Double doubleValue = measure.getValue();
        String stringValue = measure.getData();
        return MeasureValueFormatter.formatMeasureValue(doubleValue == null ? Double.NaN : doubleValue, stringValue, metric);
    }

    @CheckForNull
    static String formatMeasureValue(double doubleValue, @Nullable String stringValue, MetricDto metric) {
        Metric.ValueType metricType = Metric.ValueType.valueOf((String)metric.getValueType());
        switch (metricType) {
            case BOOL: {
                return MeasureValueFormatter.formatBoolean(doubleValue);
            }
            case INT: {
                return MeasureValueFormatter.formatInteger(doubleValue);
            }
            case MILLISEC: 
            case WORK_DUR: {
                return MeasureValueFormatter.formatLong(doubleValue);
            }
            case FLOAT: 
            case PERCENT: 
            case RATING: {
                return String.valueOf(doubleValue);
            }
            case LEVEL: 
            case STRING: 
            case DATA: 
            case DISTRIB: {
                return stringValue;
            }
        }
        throw new IllegalArgumentException("Unsupported metric type: " + metricType.name());
    }

    static String formatNumericalValue(double value, MetricDto metric) {
        Metric.ValueType metricType = Metric.ValueType.valueOf((String)metric.getValueType());
        switch (metricType) {
            case BOOL: {
                return MeasureValueFormatter.formatBoolean(value);
            }
            case INT: {
                return MeasureValueFormatter.formatInteger(value);
            }
            case MILLISEC: 
            case WORK_DUR: {
                return MeasureValueFormatter.formatLong(value);
            }
            case FLOAT: 
            case PERCENT: 
            case RATING: {
                return String.valueOf(value);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported metric type '%s' for numerical value", metricType.name()));
    }

    private static String formatBoolean(double value) {
        return Math.abs(value - 1.0) < 1.0E-6 ? "true" : "false";
    }

    private static String formatInteger(double value) {
        return String.valueOf((int)value);
    }

    private static String formatLong(double value) {
        return String.valueOf((long)value);
    }
}

