/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.organization.ws;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.CheckForNull;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.server.organization.OrganizationValidation;
import org.sonarqube.ws.Organizations;

public class OrganizationsWsSupport {
    static final String PARAM_ORGANIZATION = "organization";
    static final String PARAM_KEY = "key";
    static final String PARAM_NAME = "name";
    static final String PARAM_DESCRIPTION = "description";
    static final String PARAM_URL = "url";
    static final String PARAM_AVATAR_URL = "avatar";
    static final String PARAM_LOGIN = "login";
    private final OrganizationValidation organizationValidation;
    private final DbClient dbClient;

    public OrganizationsWsSupport(OrganizationValidation organizationValidation, DbClient dbClient) {
        this.organizationValidation = organizationValidation;
        this.dbClient = dbClient;
    }

    String getAndCheckMandatoryName(Request request) {
        String name = request.mandatoryParam(PARAM_NAME);
        this.organizationValidation.checkName(name);
        return name;
    }

    @CheckForNull
    String getAndCheckName(Request request) {
        String name = request.param(PARAM_NAME);
        if (name != null) {
            this.organizationValidation.checkName(name);
        }
        return name;
    }

    @CheckForNull
    String getAndCheckAvatar(Request request) {
        return this.organizationValidation.checkAvatar(request.param(PARAM_AVATAR_URL));
    }

    @CheckForNull
    String getAndCheckUrl(Request request) {
        return this.organizationValidation.checkUrl(request.param(PARAM_URL));
    }

    @CheckForNull
    String getAndCheckDescription(Request request) {
        return this.organizationValidation.checkDescription(request.param(PARAM_DESCRIPTION));
    }

    void addOrganizationDetailsParams(WebService.NewAction action, boolean isNameRequired) {
        action.createParam(PARAM_NAME).setRequired(isNameRequired).setMinimumLength(Integer.valueOf(1)).setMaximumLength(Integer.valueOf(255)).setDescription("Name of the organization").setExampleValue((Object)"Foo Company");
        action.createParam(PARAM_DESCRIPTION).setRequired(false).setMaximumLength(Integer.valueOf(256)).setDescription("Description of the organization.<br/> It must be less than 256 chars long.").setExampleValue((Object)"The Foo company produces quality software for Bar.");
        action.createParam(PARAM_URL).setRequired(false).setMaximumLength(Integer.valueOf(256)).setDescription("URL of the organization.<br/> It must be less than 256 chars long.").setExampleValue((Object)"https://www.foo.com");
        action.createParam(PARAM_AVATAR_URL).setRequired(false).setMaximumLength(Integer.valueOf(256)).setDescription("URL of the organization avatar.<br/> It must be less than 256 chars long.").setExampleValue((Object)"https://www.foo.com/foo.png");
    }

    Organizations.Organization.Builder toOrganization(OrganizationDto dto) {
        Organizations.Organization.Builder builder = Organizations.Organization.newBuilder();
        builder.setName(dto.getName()).setKey(dto.getKey()).setGuarded(dto.isGuarded());
        Optional.ofNullable(dto.getDescription()).ifPresent(arg_0 -> ((Organizations.Organization.Builder)builder).setDescription(arg_0));
        Optional.ofNullable(dto.getUrl()).ifPresent(arg_0 -> ((Organizations.Organization.Builder)builder).setUrl(arg_0));
        Optional.ofNullable(dto.getAvatarUrl()).ifPresent(arg_0 -> ((Organizations.Organization.Builder)builder).setAvatar(arg_0));
        return builder;
    }

    void checkMemberSyncIsDisabled(DbSession dbSession, OrganizationDto organization) {
        this.dbClient.organizationAlmBindingDao().selectByOrganization(dbSession, organization).ifPresent(orgAlmBindingDto -> Preconditions.checkArgument((!orgAlmBindingDto.isMembersSyncEnable() ? 1 : 0) != 0, (Object)"You can't add or remove members when synchronization of organization with alm is enabled."));
    }
}

