/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.ws;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Optional;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.server.exceptions.NotFoundException;
import org.sonar.server.permission.PermissionChange;
import org.sonar.server.permission.PermissionPrivilegeChecker;
import org.sonar.server.permission.PermissionService;
import org.sonar.server.permission.PermissionUpdater;
import org.sonar.server.permission.ProjectId;
import org.sonar.server.permission.UserId;
import org.sonar.server.permission.UserPermissionChange;
import org.sonar.server.permission.ws.PermissionWsSupport;
import org.sonar.server.permission.ws.PermissionsWsAction;
import org.sonar.server.permission.ws.WsParameters;
import org.sonar.server.user.UserSession;

public class AddUserAction
implements PermissionsWsAction {
    public static final String ACTION = "add_user";
    private final DbClient dbClient;
    private final UserSession userSession;
    private final PermissionUpdater permissionUpdater;
    private final PermissionWsSupport wsSupport;
    private final WsParameters wsParameters;
    private final PermissionService permissionService;

    public AddUserAction(DbClient dbClient, UserSession userSession, PermissionUpdater permissionUpdater, PermissionWsSupport wsSupport, WsParameters wsParameters, PermissionService permissionService) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.permissionUpdater = permissionUpdater;
        this.wsSupport = wsSupport;
        this.wsParameters = wsParameters;
        this.permissionService = permissionService;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction(ACTION).setDescription("Add permission to a user.<br /> This service defaults to global permissions, but can be limited to project permissions by providing project id or project key.<br />Requires one of the following permissions:<ul><li>'Administer System'</li><li>'Administer' rights on the specified project</li></ul>").setSince("5.2").setPost(true).setHandler((RequestHandler)this).setChangelog(new Change[]{new Change("7.4", "If organizationKey and projectId are both set, the organisationKey must be the key of the organization of the project")});
        this.wsParameters.createPermissionParameter(action);
        WsParameters.createUserLoginParameter(action);
        WsParameters.createProjectParameters(action);
        WsParameters.createOrganizationParameter(action).setSince("6.2");
    }

    public void handle(Request request, Response response) throws Exception {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            UserId user = this.wsSupport.findUser(dbSession, request.mandatoryParam("login"));
            Optional<ComponentDto> project = this.wsSupport.findProject(dbSession, request);
            String organizationKey = request.param("organization");
            OrganizationDto org = (OrganizationDto)project.map(dto -> this.dbClient.organizationDao().selectByUuid(dbSession, dto.getOrganizationUuid())).orElseGet(() -> Optional.ofNullable(this.wsSupport.findOrganization(dbSession, organizationKey))).orElseThrow(() -> new NotFoundException(String.format("Organization with key '%s' not found", organizationKey)));
            Preconditions.checkArgument((organizationKey == null || org.getKey().equals(organizationKey) ? 1 : 0) != 0, (Object)"Organization key is incorrect.");
            this.wsSupport.checkMembership(dbSession, org, user);
            Optional<ProjectId> projectId = project.map(ProjectId::new);
            PermissionPrivilegeChecker.checkProjectAdmin(this.userSession, org.getUuid(), projectId);
            UserPermissionChange change = new UserPermissionChange(PermissionChange.Operation.ADD, org.getUuid(), request.mandatoryParam("permission"), projectId.orElse(null), user, this.permissionService);
            this.permissionUpdater.apply(dbSession, Collections.singletonList(change));
        }
        response.noContent();
    }
}

