/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.ws;

import java.util.Arrays;
import java.util.Optional;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.server.permission.GroupPermissionChange;
import org.sonar.server.permission.PermissionChange;
import org.sonar.server.permission.PermissionPrivilegeChecker;
import org.sonar.server.permission.PermissionService;
import org.sonar.server.permission.PermissionUpdater;
import org.sonar.server.permission.ProjectId;
import org.sonar.server.permission.ws.PermissionWsSupport;
import org.sonar.server.permission.ws.PermissionsWsAction;
import org.sonar.server.permission.ws.WsParameters;
import org.sonar.server.user.UserSession;
import org.sonar.server.usergroups.ws.GroupIdOrAnyone;

public class RemoveGroupAction
implements PermissionsWsAction {
    public static final String ACTION = "remove_group";
    private final DbClient dbClient;
    private final UserSession userSession;
    private final PermissionUpdater permissionUpdater;
    private final PermissionWsSupport wsSupport;
    private final WsParameters wsParameters;
    private final PermissionService permissionService;

    public RemoveGroupAction(DbClient dbClient, UserSession userSession, PermissionUpdater permissionUpdater, PermissionWsSupport wsSupport, WsParameters wsParameters, PermissionService permissionService) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.permissionUpdater = permissionUpdater;
        this.wsSupport = wsSupport;
        this.wsParameters = wsParameters;
        this.permissionService = permissionService;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction(ACTION).setDescription("Remove a permission from a group.<br /> This service defaults to global permissions, but can be limited to project permissions by providing project id or project key.<br /> The group id or group name must be provided, not both.<br />Requires one of the following permissions:<ul><li>'Administer System'</li><li>'Administer' rights on the specified project</li></ul>").setSince("5.2").setPost(true).setHandler((RequestHandler)this);
        this.wsParameters.createPermissionParameter(action);
        WsParameters.createOrganizationParameter(action).setSince("6.2");
        WsParameters.createGroupNameParameter(action);
        WsParameters.createGroupIdParameter(action);
        WsParameters.createProjectParameters(action);
    }

    public void handle(Request request, Response response) throws Exception {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            GroupIdOrAnyone group = this.wsSupport.findGroup(dbSession, request);
            Optional<ProjectId> projectId = this.wsSupport.findProjectId(dbSession, request);
            PermissionPrivilegeChecker.checkProjectAdmin(this.userSession, group.getOrganizationUuid(), projectId);
            GroupPermissionChange change = new GroupPermissionChange(PermissionChange.Operation.REMOVE, request.mandatoryParam("permission"), projectId.orElse(null), group, this.permissionService);
            this.permissionUpdater.apply(dbSession, Arrays.asList(change));
        }
        response.noContent();
    }
}

