/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.ws;

import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.ibatis.session.ResultContext;
import org.sonar.api.i18n.I18n;
import org.sonar.api.resources.ResourceType;
import org.sonar.api.resources.ResourceTypes;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.Paging;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.ComponentQuery;
import org.sonar.db.permission.CountPerProjectPermission;
import org.sonar.server.permission.PermissionPrivilegeChecker;
import org.sonar.server.permission.PermissionService;
import org.sonar.server.permission.ProjectId;
import org.sonar.server.permission.ws.PermissionWsSupport;
import org.sonar.server.permission.ws.PermissionsWsAction;
import org.sonar.server.permission.ws.ProjectWsRef;
import org.sonar.server.permission.ws.RequestValidator;
import org.sonar.server.permission.ws.SearchProjectPermissionsData;
import org.sonar.server.permission.ws.WsParameters;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsParameterBuilder;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Common;
import org.sonarqube.ws.Permissions;

public class SearchProjectPermissionsAction
implements PermissionsWsAction {
    private static final String PROPERTY_PREFIX = "projects_role.";
    private static final String DESCRIPTION_SUFFIX = ".desc";
    private final DbClient dbClient;
    private final UserSession userSession;
    private final I18n i18n;
    private final ResourceTypes resourceTypes;
    private final PermissionWsSupport wsSupport;
    private final String[] rootQualifiers;
    private final PermissionService permissionService;

    public SearchProjectPermissionsAction(DbClient dbClient, UserSession userSession, I18n i18n, ResourceTypes resourceTypes, PermissionWsSupport wsSupport, PermissionService permissionService) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.i18n = i18n;
        this.resourceTypes = resourceTypes;
        this.wsSupport = wsSupport;
        this.rootQualifiers = Collections2.transform((Collection)resourceTypes.getRoots(), ResourceType::getQualifier).toArray(new String[resourceTypes.getRoots().size()]);
        this.permissionService = permissionService;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("search_project_permissions").setDescription("List project permissions. A project can be a technical project, a view or a developer.<br />Requires one of the following permissions:<ul><li>'Administer System'</li><li>'Administer' rights on the specified project</li></ul>").setResponseExample(this.getClass().getResource("search_project_permissions-example.json")).setSince("5.2").setDeprecatedSince("6.5").addPagingParams(25).setHandler((RequestHandler)this);
        action.createParam("q").setDescription("Limit search to: <ul><li>project names that contain the supplied string</li><li>project keys that are exactly the same as the supplied string</li></ul>").setExampleValue((Object)"apac");
        WsParameters.createProjectParameters(action);
        WsParameterBuilder.createRootQualifierParameter(action, WsParameterBuilder.QualifierParameterContext.newQualifierParameterContext(this.i18n, this.resourceTypes)).setSince("5.3");
    }

    public void handle(Request wsRequest, Response wsResponse) throws Exception {
        Permissions.SearchProjectPermissionsWsResponse searchProjectPermissionsWsResponse = this.doHandle(SearchProjectPermissionsAction.toSearchProjectPermissionsWsRequest(wsRequest));
        WsUtils.writeProtobuf((Message)searchProjectPermissionsWsResponse, wsRequest, wsResponse);
    }

    private Permissions.SearchProjectPermissionsWsResponse doHandle(SearchProjectPermissionsRequest request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            this.checkAuthorized(dbSession, request);
            RequestValidator.validateQualifier(request.getQualifier(), this.resourceTypes);
            SearchProjectPermissionsData data = this.load(dbSession, request);
            Permissions.SearchProjectPermissionsWsResponse searchProjectPermissionsWsResponse = this.buildResponse(data);
            return searchProjectPermissionsWsResponse;
        }
    }

    private static SearchProjectPermissionsRequest toSearchProjectPermissionsWsRequest(Request request) {
        return new SearchProjectPermissionsRequest().setProjectId(request.param("projectId")).setProjectKey(request.param("projectKey")).setQualifier(request.param("qualifier")).setPage(request.mandatoryParamAsInt("p")).setPageSize(request.mandatoryParamAsInt("ps")).setQuery(request.param("q"));
    }

    private void checkAuthorized(DbSession dbSession, SearchProjectPermissionsRequest request) {
        com.google.common.base.Optional<ProjectWsRef> projectRef = ProjectWsRef.newOptionalWsProjectRef(request.getProjectId(), request.getProjectKey());
        if (projectRef.isPresent()) {
            ComponentDto project = this.wsSupport.getRootComponentOrModule(dbSession, (ProjectWsRef)projectRef.get());
            PermissionPrivilegeChecker.checkProjectAdmin(this.userSession, project.getOrganizationUuid(), Optional.of(new ProjectId(project)));
        } else {
            this.userSession.checkLoggedIn().checkIsSystemAdministrator();
        }
    }

    private Permissions.SearchProjectPermissionsWsResponse buildResponse(SearchProjectPermissionsData data) {
        Permissions.SearchProjectPermissionsWsResponse.Builder response = Permissions.SearchProjectPermissionsWsResponse.newBuilder();
        Permissions.Permission.Builder permissionResponse = Permissions.Permission.newBuilder();
        Permissions.SearchProjectPermissionsWsResponse.Project.Builder rootComponentBuilder = Permissions.SearchProjectPermissionsWsResponse.Project.newBuilder();
        for (ComponentDto rootComponent : data.rootComponents()) {
            rootComponentBuilder.clear().setId(rootComponent.uuid()).setKey(rootComponent.getDbKey()).setQualifier(rootComponent.qualifier()).setName(rootComponent.name());
            for (String permission : data.permissions(rootComponent.getId())) {
                rootComponentBuilder.addPermissions(permissionResponse.clear().setKey(permission).setUsersCount(data.userCount(rootComponent.getId(), permission)).setGroupsCount(data.groupCount(rootComponent.getId(), permission)));
            }
            response.addProjects(rootComponentBuilder);
        }
        for (String permissionKey : this.permissionService.getAllProjectPermissions()) {
            response.addPermissions(permissionResponse.clear().setKey(permissionKey).setName(this.i18nName(permissionKey)).setDescription(this.i18nDescriptionMessage(permissionKey)));
        }
        Paging paging = data.paging();
        response.setPaging(Common.Paging.newBuilder().setPageIndex(paging.pageIndex()).setPageSize(paging.pageSize()).setTotal(paging.total()));
        return response.build();
    }

    private String i18nDescriptionMessage(String permissionKey) {
        return this.i18n.message(Locale.ENGLISH, PROPERTY_PREFIX + permissionKey + DESCRIPTION_SUFFIX, "", new Object[0]);
    }

    private String i18nName(String permissionKey) {
        return this.i18n.message(Locale.ENGLISH, PROPERTY_PREFIX + permissionKey, permissionKey, new Object[0]);
    }

    private SearchProjectPermissionsData load(DbSession dbSession, SearchProjectPermissionsRequest request) {
        SearchProjectPermissionsData.Builder data = SearchProjectPermissionsData.newBuilder();
        int countRootComponents = this.countRootComponents(dbSession, request);
        List<ComponentDto> rootComponents = this.searchRootComponents(dbSession, request, SearchProjectPermissionsAction.paging(request, countRootComponents));
        List rootComponentIds = Lists.transform(rootComponents, ComponentDto::getId);
        data.rootComponents(rootComponents).paging(SearchProjectPermissionsAction.paging(request, countRootComponents)).userCountByProjectIdAndPermission(this.userCountByRootComponentIdAndPermission(dbSession, rootComponentIds)).groupCountByProjectIdAndPermission(this.groupCountByRootComponentIdAndPermission(dbSession, rootComponentIds));
        return data.build();
    }

    private static Paging paging(SearchProjectPermissionsRequest request, int total) {
        return Paging.forPageIndex((int)request.getPage()).withPageSize(request.getPageSize().intValue()).andTotal(total);
    }

    private int countRootComponents(DbSession dbSession, SearchProjectPermissionsRequest request) {
        return this.dbClient.componentDao().countByQuery(dbSession, this.toDbQuery(request));
    }

    private List<ComponentDto> searchRootComponents(DbSession dbSession, SearchProjectPermissionsRequest request, Paging paging) {
        com.google.common.base.Optional<ProjectWsRef> project = ProjectWsRef.newOptionalWsProjectRef(request.getProjectId(), request.getProjectKey());
        if (project.isPresent()) {
            return Collections.singletonList(this.wsSupport.getRootComponentOrModule(dbSession, (ProjectWsRef)project.get()));
        }
        return this.dbClient.componentDao().selectByQuery(dbSession, this.toDbQuery(request), paging.offset(), paging.pageSize());
    }

    private ComponentQuery toDbQuery(SearchProjectPermissionsRequest wsRequest) {
        return ComponentQuery.builder().setQualifiers(this.qualifiers(wsRequest.getQualifier())).setNameOrKeyQuery(wsRequest.getQuery()).build();
    }

    private String[] qualifiers(@Nullable String requestQualifier) {
        String[] stringArray;
        if (requestQualifier == null) {
            stringArray = this.rootQualifiers;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = requestQualifier;
        }
        return stringArray;
    }

    private Table<Long, String, Integer> userCountByRootComponentIdAndPermission(DbSession dbSession, List<Long> rootComponentIds) {
        TreeBasedTable userCountByRootComponentIdAndPermission = TreeBasedTable.create();
        this.dbClient.userPermissionDao().countUsersByProjectPermission(dbSession, rootComponentIds).forEach(arg_0 -> SearchProjectPermissionsAction.lambda$userCountByRootComponentIdAndPermission$0((Table)userCountByRootComponentIdAndPermission, arg_0));
        return userCountByRootComponentIdAndPermission;
    }

    private Table<Long, String, Integer> groupCountByRootComponentIdAndPermission(DbSession dbSession, List<Long> rootComponentIds) {
        TreeBasedTable userCountByRootComponentIdAndPermission = TreeBasedTable.create();
        this.dbClient.groupPermissionDao().groupsCountByComponentIdAndPermission(dbSession, rootComponentIds, arg_0 -> SearchProjectPermissionsAction.lambda$groupCountByRootComponentIdAndPermission$1((Table)userCountByRootComponentIdAndPermission, arg_0));
        return userCountByRootComponentIdAndPermission;
    }

    private static /* synthetic */ void lambda$groupCountByRootComponentIdAndPermission$1(Table userCountByRootComponentIdAndPermission, ResultContext context) {
        CountPerProjectPermission row = (CountPerProjectPermission)context.getResultObject();
        userCountByRootComponentIdAndPermission.put((Object)row.getComponentId(), (Object)row.getPermission(), (Object)row.getCount());
    }

    private static /* synthetic */ void lambda$userCountByRootComponentIdAndPermission$0(Table userCountByRootComponentIdAndPermission, CountPerProjectPermission row) {
        Integer cfr_ignored_0 = (Integer)userCountByRootComponentIdAndPermission.put((Object)row.getComponentId(), (Object)row.getPermission(), (Object)row.getCount());
    }

    private static class SearchProjectPermissionsRequest {
        private String projectId;
        private String projectKey;
        private String qualifier;
        private Integer page;
        private Integer pageSize;
        private String query;

        private SearchProjectPermissionsRequest() {
        }

        @CheckForNull
        public String getProjectId() {
            return this.projectId;
        }

        public SearchProjectPermissionsRequest setProjectId(@Nullable String projectId) {
            this.projectId = projectId;
            return this;
        }

        @CheckForNull
        public String getProjectKey() {
            return this.projectKey;
        }

        public SearchProjectPermissionsRequest setProjectKey(@Nullable String projectKey) {
            this.projectKey = projectKey;
            return this;
        }

        @CheckForNull
        public Integer getPage() {
            return this.page;
        }

        public SearchProjectPermissionsRequest setPage(int page) {
            this.page = page;
            return this;
        }

        @CheckForNull
        public Integer getPageSize() {
            return this.pageSize;
        }

        public SearchProjectPermissionsRequest setPageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        @CheckForNull
        public String getQuery() {
            return this.query;
        }

        public SearchProjectPermissionsRequest setQuery(@Nullable String query) {
            this.query = query;
            return this;
        }

        @CheckForNull
        public String getQualifier() {
            return this.qualifier;
        }

        public SearchProjectPermissionsRequest setQualifier(@Nullable String qualifier) {
            this.qualifier = qualifier;
            return this;
        }
    }
}

