/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.ws.template;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.System2;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.permission.template.PermissionTemplateCharacteristicDto;
import org.sonar.db.permission.template.PermissionTemplateDto;
import org.sonar.server.permission.PermissionPrivilegeChecker;
import org.sonar.server.permission.ws.PermissionWsSupport;
import org.sonar.server.permission.ws.PermissionsWsAction;
import org.sonar.server.permission.ws.RequestValidator;
import org.sonar.server.permission.ws.WsParameters;
import org.sonar.server.permission.ws.template.WsTemplateRef;
import org.sonar.server.user.UserSession;

public class AddProjectCreatorToTemplateAction
implements PermissionsWsAction {
    private final DbClient dbClient;
    private final PermissionWsSupport wsSupport;
    private final UserSession userSession;
    private final System2 system;
    private final WsParameters wsParameters;
    private final RequestValidator requestValidator;

    public AddProjectCreatorToTemplateAction(DbClient dbClient, PermissionWsSupport wsSupport, UserSession userSession, System2 system, WsParameters wsParameters, RequestValidator requestValidator) {
        this.dbClient = dbClient;
        this.wsSupport = wsSupport;
        this.userSession = userSession;
        this.system = system;
        this.wsParameters = wsParameters;
        this.requestValidator = requestValidator;
    }

    private AddProjectCreatorToTemplateRequest toWsRequest(Request request) {
        AddProjectCreatorToTemplateRequest wsRequest = AddProjectCreatorToTemplateRequest.builder().setPermission(request.mandatoryParam("permission")).setTemplateId(request.param("templateId")).setOrganization(request.param("organization")).setTemplateName(request.param("templateName")).build();
        this.requestValidator.validateProjectPermission(wsRequest.getPermission());
        return wsRequest;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("add_project_creator_to_template").setDescription("Add a project creator to a permission template.<br>Requires the following permission: 'Administer System'.").setSince("6.0").setPost(true).setHandler((RequestHandler)this);
        WsParameters.createTemplateParameters(action);
        this.wsParameters.createProjectPermissionParameter(action);
    }

    public void handle(Request request, Response response) throws Exception {
        this.doHandle(this.toWsRequest(request));
        response.noContent();
    }

    private void doHandle(AddProjectCreatorToTemplateRequest request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            PermissionTemplateDto template = this.wsSupport.findTemplate(dbSession, WsTemplateRef.newTemplateRef(request.getTemplateId(), request.getOrganization(), request.getTemplateName()));
            PermissionPrivilegeChecker.checkGlobalAdmin(this.userSession, template.getOrganizationUuid());
            Optional templatePermission = this.dbClient.permissionTemplateCharacteristicDao().selectByPermissionAndTemplateId(dbSession, request.getPermission(), template.getId().longValue());
            if (templatePermission.isPresent()) {
                this.updateTemplatePermission(dbSession, (PermissionTemplateCharacteristicDto)templatePermission.get());
            } else {
                this.addTemplatePermission(dbSession, request, template);
            }
        }
    }

    private void addTemplatePermission(DbSession dbSession, AddProjectCreatorToTemplateRequest request, PermissionTemplateDto template) {
        long now = this.system.now();
        this.dbClient.permissionTemplateCharacteristicDao().insert(dbSession, new PermissionTemplateCharacteristicDto().setPermission(request.getPermission()).setTemplateId(template.getId().longValue()).setWithProjectCreator(true).setCreatedAt(now).setUpdatedAt(now));
        dbSession.commit();
    }

    private void updateTemplatePermission(DbSession dbSession, PermissionTemplateCharacteristicDto templatePermission) {
        PermissionTemplateCharacteristicDto targetTemplatePermission = templatePermission.setUpdatedAt(this.system.now()).setWithProjectCreator(true);
        this.dbClient.permissionTemplateCharacteristicDao().update(dbSession, targetTemplatePermission);
        dbSession.commit();
    }

    private static class Builder {
        private String templateId;
        private String organization;
        private String templateName;
        private String permission;

        private Builder() {
        }

        public Builder setTemplateId(@Nullable String templateId) {
            this.templateId = templateId;
            return this;
        }

        public Builder setOrganization(@Nullable String s) {
            this.organization = s;
            return this;
        }

        public Builder setTemplateName(@Nullable String templateName) {
            this.templateName = templateName;
            return this;
        }

        public Builder setPermission(@Nullable String permission) {
            this.permission = permission;
            return this;
        }

        public AddProjectCreatorToTemplateRequest build() {
            return new AddProjectCreatorToTemplateRequest(this);
        }
    }

    private static class AddProjectCreatorToTemplateRequest {
        private final String templateId;
        private final String organization;
        private final String templateName;
        private final String permission;

        private AddProjectCreatorToTemplateRequest(Builder builder) {
            this.templateId = builder.templateId;
            this.organization = builder.organization;
            this.templateName = builder.templateName;
            this.permission = Objects.requireNonNull(builder.permission);
        }

        @CheckForNull
        public String getTemplateId() {
            return this.templateId;
        }

        @CheckForNull
        public String getOrganization() {
            return this.organization;
        }

        @CheckForNull
        public String getTemplateName() {
            return this.templateName;
        }

        public String getPermission() {
            return this.permission;
        }

        public static Builder builder() {
            return new Builder();
        }
    }
}

