/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform;

import com.google.common.collect.ImmutableMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.log.Loggers;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.version.SqTables;
import org.sonar.server.component.index.ComponentIndexDefinition;
import org.sonar.server.es.BulkIndexer;
import org.sonar.server.es.EsClient;
import org.sonar.server.es.Index;
import org.sonar.server.es.IndexType;
import org.sonar.server.issue.index.IssueIndexDefinition;
import org.sonar.server.measure.index.ProjectMeasuresIndexDefinition;
import org.sonar.server.view.index.ViewIndexDefinition;

@ServerSide
public class BackendCleanup {
    private static final String[] ANALYSIS_TABLES = new String[]{"ce_activity", "ce_queue", "ce_task_input", "ce_scanner_context", "duplications_index", "events", "issues", "issue_changes", "manual_measures", "notifications", "project_links", "project_measures", "projects", "snapshots", "file_sources", "webhook_deliveries"};
    private static final String[] RESOURCE_RELATED_TABLES = new String[]{"group_roles", "user_roles", "properties"};
    private static final Map<String, TableCleaner> TABLE_CLEANERS = ImmutableMap.of((Object)"organizations", BackendCleanup::truncateOrganizations, (Object)"users", BackendCleanup::truncateUsers, (Object)"groups", BackendCleanup::truncateGroups, (Object)"internal_properties", BackendCleanup::truncateInternalProperties, (Object)"schema_migrations", BackendCleanup::truncateSchemaMigrations);
    private final EsClient esClient;
    private final DbClient dbClient;

    public BackendCleanup(EsClient esClient, DbClient dbClient) {
        this.esClient = esClient;
        this.dbClient = dbClient;
    }

    public void clearAll() {
        this.clearDb();
        this.clearIndexes();
    }

    public void clearDb() {
        try (DbSession dbSession = this.dbClient.openSession(false);
             Connection connection = dbSession.getConnection();
             Statement ddlStatement = connection.createStatement();){
            for (String tableName : SqTables.TABLES) {
                Optional.ofNullable(TABLE_CLEANERS.get(tableName)).orElse(BackendCleanup::truncateDefault).clean(tableName, ddlStatement, connection);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to clear db", e);
        }
    }

    public void clearIndexes() {
        Loggers.get(this.getClass()).info("Truncate Elasticsearch indices");
        try {
            this.esClient.prepareClearCache(new String[0]).get();
            for (String index : ((ClusterStateResponse)this.esClient.prepareState().get()).getState().getMetaData().getConcreteAllIndices()) {
                this.clearIndex(Index.simple((String)index));
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to clear indexes", e);
        }
    }

    public void resetData() {
        try (DbSession dbSession = this.dbClient.openSession(false);
             Connection connection = dbSession.getConnection();){
            this.truncateAnalysisTables(connection);
            BackendCleanup.deleteManualRules(connection);
            BackendCleanup.truncateInternalProperties(null, null, connection);
            BackendCleanup.truncateUsers(null, null, connection);
            BackendCleanup.truncateOrganizations(null, null, connection);
        }
        catch (SQLException e) {
            throw new IllegalStateException("Fail to reset data", e);
        }
        this.clearIndex(IssueIndexDefinition.DESCRIPTOR);
        this.clearIndex(ViewIndexDefinition.DESCRIPTOR);
        this.clearIndex(ProjectMeasuresIndexDefinition.DESCRIPTOR);
        this.clearIndex(ComponentIndexDefinition.DESCRIPTOR);
    }

    private void truncateAnalysisTables(Connection connection) throws SQLException {
        try (Statement statement = connection.createStatement();){
            for (String table : ANALYSIS_TABLES) {
                statement.execute(this.createTruncateSql(table.toLowerCase(Locale.ENGLISH)));
                connection.commit();
            }
            for (String table : RESOURCE_RELATED_TABLES) {
                statement.execute("DELETE FROM " + table + " WHERE resource_id IS NOT NULL");
                connection.commit();
            }
        }
    }

    private String createTruncateSql(String table) {
        if (this.dbClient.getDatabase().getDialect().getId().equals("oracle")) {
            return "DELETE FROM " + table;
        }
        return "TRUNCATE TABLE " + table;
    }

    private static void deleteManualRules(Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement("DELETE FROM rules WHERE rules.plugin_name='manual'");){
            statement.execute();
            connection.commit();
        }
    }

    public void clearIndex(Index index) {
        BulkIndexer.delete((EsClient)this.esClient, (IndexType)IndexType.main((Index)index, (String)index.getName()), (SearchRequestBuilder)this.esClient.prepareSearch(index).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()));
    }

    private static void truncateDefault(String tableName, Statement ddlStatement, Connection connection) throws SQLException {
        ddlStatement.execute("TRUNCATE TABLE " + tableName.toLowerCase(Locale.ENGLISH));
        connection.commit();
    }

    private static void truncateOrganizations(String tableName, Statement ddlStatement, Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("delete from organizations where kee <> ?");){
            preparedStatement.setString(1, "default-organization");
            preparedStatement.execute();
            connection.commit();
        }
    }

    private static void truncateUsers(String tableName, Statement ddlStatement, Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("delete from users where login <> ?");){
            preparedStatement.setString(1, "admin");
            preparedStatement.execute();
            connection.commit();
        }
        preparedStatement = connection.prepareStatement("update users set is_root=?");
        var4_4 = null;
        try {
            preparedStatement.setBoolean(1, false);
            preparedStatement.execute();
            connection.commit();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (preparedStatement != null) {
                if (var4_4 != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    preparedStatement.close();
                }
            }
        }
    }

    private static void truncateGroups(String tableName, Statement ddlStatement, Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("delete from groups where name <> ?");){
            preparedStatement.setString(1, "sonar-users");
            preparedStatement.execute();
            connection.commit();
        }
    }

    private static void truncateInternalProperties(String tableName, Statement ddlStatement, Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement("delete from internal_properties where kee not in (?,?)");){
            preparedStatement.setString(1, "organization.default");
            preparedStatement.setString(2, "server.idChecksum");
            preparedStatement.execute();
            connection.commit();
        }
    }

    private static void truncateSchemaMigrations(String tableName, Statement ddlStatement, Connection connection) {
    }

    @FunctionalInterface
    private static interface TableCleaner {
        public void clean(String var1, Statement var2, Connection var3) throws SQLException;
    }
}

