/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.monitoring;

import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsResponse;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.sonar.api.utils.log.Loggers;
import org.sonar.process.systeminfo.SystemInfoSection;
import org.sonar.process.systeminfo.SystemInfoUtils;
import org.sonar.process.systeminfo.protobuf.ProtobufSystemInfo;
import org.sonar.server.es.EsClient;

public class EsStateSection
implements SystemInfoSection {
    private final EsClient esClient;

    public EsStateSection(EsClient esClient) {
        this.esClient = esClient;
    }

    private ClusterHealthStatus getStateAsEnum() {
        return this.clusterStats().getStatus();
    }

    public ProtobufSystemInfo.Section toProtobuf() {
        ProtobufSystemInfo.Section.Builder protobuf = ProtobufSystemInfo.Section.newBuilder();
        protobuf.setName("Search State");
        try {
            SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"State", (String)this.getStateAsEnum().name());
            this.completeNodeAttributes(protobuf);
        }
        catch (Exception es) {
            Loggers.get(EsStateSection.class).warn("Failed to retrieve ES attributes. There will be only a single \"state\" attribute.", (Throwable)es);
            SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"State", (String)(es.getCause() instanceof ElasticsearchException ? es.getCause().getMessage() : es.getMessage()));
        }
        return protobuf.build();
    }

    private void completeNodeAttributes(ProtobufSystemInfo.Section.Builder protobuf) {
        NodesStatsResponse nodesStats = (NodesStatsResponse)this.esClient.prepareNodesStats(new String[0]).setFs(true).setProcess(true).setJvm(true).setIndices(true).setBreaker(true).get();
        if (!nodesStats.getNodes().isEmpty()) {
            NodeStats stats = (NodeStats)nodesStats.getNodes().get(0);
            EsStateSection.toProtobuf(stats, protobuf);
        }
    }

    public static void toProtobuf(NodeStats stats, ProtobufSystemInfo.Section.Builder protobuf) {
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"CPU Usage (%)", (long)stats.getProcess().getCpu().getPercent());
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Disk Available", (String)FileUtils.byteCountToDisplaySize((long)stats.getFs().getTotal().getAvailable().getBytes()));
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Store Size", (String)FileUtils.byteCountToDisplaySize((long)stats.getIndices().getStore().getSizeInBytes()));
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Translog Size", (String)FileUtils.byteCountToDisplaySize((long)stats.getIndices().getTranslog().getTranslogSizeInBytes()));
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Open File Descriptors", (long)stats.getProcess().getOpenFileDescriptors());
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Max File Descriptors", (long)stats.getProcess().getMaxFileDescriptors());
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"JVM Heap Usage", (String)EsStateSection.formatPercent(stats.getJvm().getMem().getHeapUsedPercent()));
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"JVM Heap Used", (String)FileUtils.byteCountToDisplaySize((long)stats.getJvm().getMem().getHeapUsed().getBytes()));
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"JVM Heap Max", (String)FileUtils.byteCountToDisplaySize((long)stats.getJvm().getMem().getHeapMax().getBytes()));
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"JVM Non Heap Used", (String)FileUtils.byteCountToDisplaySize((long)stats.getJvm().getMem().getNonHeapUsed().getBytes()));
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"JVM Threads", (long)stats.getJvm().getThreads().getCount());
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Field Data Memory", (String)FileUtils.byteCountToDisplaySize((long)stats.getIndices().getFieldData().getMemorySizeInBytes()));
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Field Data Circuit Breaker Limit", (String)FileUtils.byteCountToDisplaySize((long)stats.getBreaker().getStats("fielddata").getLimit()));
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Field Data Circuit Breaker Estimation", (String)FileUtils.byteCountToDisplaySize((long)stats.getBreaker().getStats("fielddata").getEstimated()));
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Request Circuit Breaker Limit", (String)FileUtils.byteCountToDisplaySize((long)stats.getBreaker().getStats("request").getLimit()));
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Request Circuit Breaker Estimation", (String)FileUtils.byteCountToDisplaySize((long)stats.getBreaker().getStats("request").getEstimated()));
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Query Cache Memory", (String)FileUtils.byteCountToDisplaySize((long)stats.getIndices().getQueryCache().getMemorySizeInBytes()));
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Request Cache Memory", (String)FileUtils.byteCountToDisplaySize((long)stats.getIndices().getRequestCache().getMemorySizeInBytes()));
    }

    private ClusterStatsResponse clusterStats() {
        return (ClusterStatsResponse)this.esClient.prepareClusterStats().get();
    }

    private static String formatPercent(long amount) {
        return String.format(Locale.ENGLISH, "%.1f%%", 100.0 * (double)amount * 1.0 / 100.0);
    }
}

