/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.monitoring;

import org.sonar.api.config.Configuration;
import org.sonar.core.platform.Module;
import org.sonar.process.systeminfo.JvmPropertiesSection;
import org.sonar.process.systeminfo.JvmStateSection;
import org.sonar.server.platform.WebServer;
import org.sonar.server.platform.monitoring.DbConnectionSection;
import org.sonar.server.platform.monitoring.DbSection;
import org.sonar.server.platform.monitoring.EsIndexesSection;
import org.sonar.server.platform.monitoring.EsStateSection;
import org.sonar.server.platform.monitoring.LoggingSection;
import org.sonar.server.platform.monitoring.PluginsSection;
import org.sonar.server.platform.monitoring.SettingsSection;
import org.sonar.server.platform.monitoring.StandaloneSystemSection;
import org.sonar.server.platform.monitoring.cluster.AppNodesInfoLoaderImpl;
import org.sonar.server.platform.monitoring.cluster.CeQueueGlobalSection;
import org.sonar.server.platform.monitoring.cluster.EsClusterStateSection;
import org.sonar.server.platform.monitoring.cluster.GlobalInfoLoader;
import org.sonar.server.platform.monitoring.cluster.GlobalSystemSection;
import org.sonar.server.platform.monitoring.cluster.NodeSystemSection;
import org.sonar.server.platform.monitoring.cluster.ProcessInfoProvider;
import org.sonar.server.platform.monitoring.cluster.SearchNodesInfoLoaderImpl;
import org.sonar.server.platform.ws.ClusterSystemInfoWriter;
import org.sonar.server.platform.ws.InfoAction;
import org.sonar.server.platform.ws.StandaloneSystemInfoWriter;

public class WebSystemInfoModule
extends Module {
    private final Configuration configuration;
    private final WebServer webServer;

    public WebSystemInfoModule(Configuration configuration, WebServer webServer) {
        this.configuration = configuration;
        this.webServer = webServer;
    }

    protected void configureModule() {
        boolean sonarcloud = this.configuration.getBoolean("sonar.sonarcloud.enabled").orElse(false);
        boolean standalone = this.webServer.isStandalone();
        this.add(new Object[]{new JvmPropertiesSection("Web JVM Properties"), new JvmStateSection("Web JVM State"), DbSection.class, DbConnectionSection.class, EsIndexesSection.class, LoggingSection.class, PluginsSection.class, SettingsSection.class, InfoAction.class});
        if (standalone || sonarcloud) {
            this.add(new Object[]{EsStateSection.class, StandaloneSystemSection.class, StandaloneSystemInfoWriter.class});
        } else {
            this.add(new Object[]{CeQueueGlobalSection.class, EsClusterStateSection.class, GlobalSystemSection.class, NodeSystemSection.class, ProcessInfoProvider.class, GlobalInfoLoader.class, AppNodesInfoLoaderImpl.class, SearchNodesInfoLoaderImpl.class, ClusterSystemInfoWriter.class});
        }
    }
}

