/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.web;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.commons.io.IOUtils;
import org.sonar.api.config.Configuration;
import org.sonar.process.ProcessProperties;
import org.sonar.server.platform.OfficialDistribution;
import org.sonar.server.platform.Platform;

public class WebPagesCache {
    private static final String WEB_CONTEXT_PLACEHOLDER = "%WEB_CONTEXT%";
    private static final String SERVER_STATUS_PLACEHOLDER = "%SERVER_STATUS%";
    private static final String INSTANCE_PLACEHOLDER = "%INSTANCE%";
    private static final String OFFICIAL_PLACEHOLDER = "%OFFICIAL%";
    private static final String SONARCLOUD_INSTANCE_VALUE = "SonarCloud";
    private static final String SONARQUBE_INSTANCE_VALUE = "SonarQube";
    private static final String INDEX_HTML_PATH = "/index.html";
    private static final Set<String> HTML_PATHS = ImmutableSet.of((Object)"/index.html", (Object)"/integration/vsts/index.html");
    private final Platform platform;
    private final Configuration configuration;
    private final OfficialDistribution officialDistribution;
    private ServletContext servletContext;
    private Map<String, String> indexHtmlByPath;
    private Platform.Status status;

    public WebPagesCache(Platform platform, Configuration configuration, OfficialDistribution officialDistribution) {
        this.platform = platform;
        this.configuration = configuration;
        this.indexHtmlByPath = new HashMap<String, String>();
        this.officialDistribution = officialDistribution;
    }

    public void init(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.generate(this.platform.status());
    }

    public String getContent(String path) {
        String htmlPath = HTML_PATHS.contains(path) ? path : INDEX_HTML_PATH;
        Preconditions.checkState((this.servletContext != null ? 1 : 0) != 0, (Object)"init has not been called");
        if (Objects.equals((Object)this.status, (Object)Platform.Status.UP)) {
            return this.indexHtmlByPath.get(htmlPath);
        }
        Platform.Status currentStatus = this.platform.status();
        if (!Objects.equals((Object)this.status, (Object)currentStatus)) {
            this.generate(currentStatus);
        }
        return this.indexHtmlByPath.get(htmlPath);
    }

    private void generate(Platform.Status status) {
        this.status = status;
        HTML_PATHS.forEach(path -> this.indexHtmlByPath.put((String)path, this.provide((String)path)));
    }

    private String provide(String path) {
        this.getClass().getResourceAsStream(INDEX_HTML_PATH);
        boolean isSonarCloud = this.configuration.getBoolean(ProcessProperties.Property.SONARCLOUD_ENABLED.getKey()).orElse(false);
        String instance = isSonarCloud ? SONARCLOUD_INSTANCE_VALUE : SONARQUBE_INSTANCE_VALUE;
        return this.loadHtmlFile(path, this.status.name(), instance);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadHtmlFile(String path, String serverStatus, String instance) {
        try (InputStream input = this.servletContext.getResourceAsStream(path);){
            String template = IOUtils.toString((InputStream)Objects.requireNonNull(input), (Charset)StandardCharsets.UTF_8);
            String string = template.replaceAll(WEB_CONTEXT_PLACEHOLDER, this.servletContext.getContextPath()).replaceAll(SERVER_STATUS_PLACEHOLDER, serverStatus).replaceAll(INSTANCE_PLACEHOLDER, instance).replaceAll(OFFICIAL_PLACEHOLDER, String.valueOf(this.officialDistribution.check()));
            return string;
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to load file " + path, e);
        }
    }
}

