/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.ws;

import com.google.common.io.Resources;
import java.util.Comparator;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.DateUtils;
import org.sonar.process.cluster.health.NodeDetails;
import org.sonar.process.cluster.health.NodeHealth;
import org.sonar.server.health.ClusterHealth;
import org.sonar.server.health.Health;
import org.sonar.server.health.HealthChecker;
import org.sonar.server.platform.ws.SystemWsAction;
import org.sonarqube.ws.System;

public class HealthActionSupport {
    private static final Comparator<NodeHealth> NODE_HEALTH_COMPARATOR = Comparator.comparingInt(s -> s.getDetails().getType().ordinal()).thenComparing(a -> a.getDetails().getName()).thenComparing(a -> a.getDetails().getHost()).thenComparing(a -> a.getDetails().getPort());
    private final HealthChecker healthChecker;

    public HealthActionSupport(HealthChecker healthChecker) {
        this.healthChecker = healthChecker;
    }

    void define(WebService.NewController controller, SystemWsAction handler) {
        controller.createAction("health").setDescription("Provide health status of SonarQube.<p>Require 'Administer System' permission or authentication with passcode</p><p>  <ul> <li>GREEN: SonarQube is fully operational</li> <li>YELLOW: SonarQube is usable, but it needs attention in order to be fully operational</li> <li>RED: SonarQube is not operational</li> </ul></p>").setSince("6.6").setResponseExample(Resources.getResource(this.getClass(), (String)"example-health.json")).setHandler((RequestHandler)handler);
    }

    System.HealthResponse checkNodeHealth() {
        Health check = this.healthChecker.checkNode();
        System.HealthResponse.Builder responseBuilder = System.HealthResponse.newBuilder().setHealth(System.Health.valueOf((String)check.getStatus().name()));
        System.Cause.Builder causeBuilder = System.Cause.newBuilder();
        check.getCauses().forEach(str -> responseBuilder.addCauses(causeBuilder.clear().setMessage(str).build()));
        return responseBuilder.build();
    }

    System.HealthResponse checkClusterHealth() {
        ClusterHealth check = this.healthChecker.checkCluster();
        return HealthActionSupport.toResponse(check);
    }

    private static System.HealthResponse toResponse(ClusterHealth check) {
        System.HealthResponse.Builder responseBuilder = System.HealthResponse.newBuilder();
        System.Node.Builder nodeBuilder = System.Node.newBuilder();
        System.Cause.Builder causeBuilder = System.Cause.newBuilder();
        Health health = check.getHealth();
        responseBuilder.setHealth(System.Health.valueOf((String)health.getStatus().name()));
        health.getCauses().forEach(str -> responseBuilder.addCauses(HealthActionSupport.toCause(str, causeBuilder)));
        System.Nodes.Builder nodesBuilder = System.Nodes.newBuilder();
        check.getNodes().stream().sorted(NODE_HEALTH_COMPARATOR).map(node -> HealthActionSupport.toNode(node, nodeBuilder, causeBuilder)).forEach(arg_0 -> ((System.Nodes.Builder)nodesBuilder).addNodes(arg_0));
        responseBuilder.setNodes(nodesBuilder.build());
        return responseBuilder.build();
    }

    private static System.Node toNode(NodeHealth nodeHealth, System.Node.Builder nodeBuilder, System.Cause.Builder causeBuilder) {
        nodeBuilder.clear();
        nodeBuilder.setHealth(System.Health.valueOf((String)nodeHealth.getStatus().name()));
        nodeHealth.getCauses().forEach(str -> nodeBuilder.addCauses(HealthActionSupport.toCause(str, causeBuilder)));
        NodeDetails details = nodeHealth.getDetails();
        nodeBuilder.setType(System.NodeType.valueOf((String)details.getType().name())).setName(details.getName()).setHost(details.getHost()).setPort(details.getPort()).setStartedAt(DateUtils.formatDateTime((long)details.getStartedAt()));
        return nodeBuilder.build();
    }

    private static System.Cause toCause(String str, System.Cause.Builder causeBuilder) {
        return causeBuilder.clear().setMessage(str).build();
    }
}

