/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.plugins;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.CheckForNull;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.extension.CoreExtensionRepository;
import org.sonar.core.platform.PluginRepository;
import org.sonar.server.platform.Platform;
import org.sonarqube.ws.MediaTypes;

public class StaticResourcesServlet
extends HttpServlet {
    private static final Logger LOG = Loggers.get(StaticResourcesServlet.class);
    private static final long serialVersionUID = -2577454614650178426L;
    private final System system;

    @VisibleForTesting
    StaticResourcesServlet(System system) {
        this.system = system;
    }

    public StaticResourcesServlet() {
        this.system = new System();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        String pluginKey = StaticResourcesServlet.getPluginKey(request);
        String resource = StaticResourcesServlet.getResourcePath(request);
        InputStream in = null;
        ServletOutputStream out = null;
        try {
            CoreExtensionRepository coreExtensionRepository = this.system.getCoreExtensionRepository();
            PluginRepository pluginRepository = this.system.getPluginRepository();
            boolean coreExtension = coreExtensionRepository.isInstalled(pluginKey);
            if (!coreExtension && !pluginRepository.hasPlugin(pluginKey)) {
                this.silentlySendError(response, 404);
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly(out);
                return;
            }
            InputStream inputStream = in = coreExtension ? this.system.openCoreExtensionResourceStream(resource) : this.system.openPluginResourceStream(pluginKey, resource, pluginRepository);
            if (in == null) {
                this.silentlySendError(response, 404);
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly((OutputStream)out);
                return;
            }
            StaticResourcesServlet.completeContentType(response, resource);
            out = response.getOutputStream();
            IOUtils.copy((InputStream)in, (OutputStream)out);
            IOUtils.closeQuietly((InputStream)in);
        }
        catch (ClientAbortException e) {
            LOG.trace("Client canceled loading resource [{}] from plugin [{}]: {}", new Object[]{resource, pluginKey, e});
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (Exception e2) {
                LOG.error(String.format("Unable to load resource [%s] from plugin [%s]", resource, pluginKey), (Throwable)e2);
                this.silentlySendError(response, 500);
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly(out);
                return;
            }
        }
        finally {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
        }
        IOUtils.closeQuietly((OutputStream)out);
        return;
    }

    private void silentlySendError(HttpServletResponse response, int error) {
        if (this.system.isCommitted(response)) {
            LOG.trace("Response is committed. Cannot send error response code {}", (Object)error);
            return;
        }
        try {
            this.system.sendError(response, error);
        }
        catch (IOException e) {
            LOG.trace("Failed to send error code {}: {}", (Object)error, (Object)e);
        }
    }

    private static String getPluginKeyAndResourcePath(HttpServletRequest request) {
        return StringUtils.substringAfter((String)request.getRequestURI(), (String)(request.getContextPath() + request.getServletPath() + "/"));
    }

    private static String getPluginKey(HttpServletRequest request) {
        return StringUtils.substringBefore((String)StaticResourcesServlet.getPluginKeyAndResourcePath(request), (String)"/");
    }

    private static String getResourcePath(HttpServletRequest request) {
        return "static/" + StringUtils.substringAfter((String)StaticResourcesServlet.getPluginKeyAndResourcePath(request), (String)"/");
    }

    private static void completeContentType(HttpServletResponse response, String filename) {
        response.setContentType(MediaTypes.getByFilename((String)filename));
    }

    static class System {
        System() {
        }

        PluginRepository getPluginRepository() {
            return (PluginRepository)Platform.getInstance().getContainer().getComponentByType(PluginRepository.class);
        }

        CoreExtensionRepository getCoreExtensionRepository() {
            return (CoreExtensionRepository)Platform.getInstance().getContainer().getComponentByType(CoreExtensionRepository.class);
        }

        @CheckForNull
        InputStream openPluginResourceStream(String pluginKey, String resource, PluginRepository pluginRepository) throws Exception {
            ClassLoader pluginClassLoader = pluginRepository.getPluginInstance(pluginKey).getClass().getClassLoader();
            return pluginClassLoader.getResourceAsStream(resource);
        }

        @CheckForNull
        InputStream openCoreExtensionResourceStream(String resource) throws Exception {
            return this.getClass().getClassLoader().getResourceAsStream(resource);
        }

        boolean isCommitted(HttpServletResponse response) {
            return response.isCommitted();
        }

        void sendError(HttpServletResponse response, int error) throws IOException {
            response.sendError(error);
        }
    }
}

