/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.project.ws;

import com.google.protobuf.Message;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.server.component.ComponentUpdater;
import org.sonar.server.component.NewComponent;
import org.sonar.server.project.Visibility;
import org.sonar.server.project.ws.ProjectsWsAction;
import org.sonar.server.project.ws.ProjectsWsSupport;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Projects;

public class CreateAction
implements ProjectsWsAction {
    private static final String DEPRECATED_PARAM_KEY = "key";
    private final ProjectsWsSupport support;
    private final DbClient dbClient;
    private final UserSession userSession;
    private final ComponentUpdater componentUpdater;

    public CreateAction(ProjectsWsSupport support, DbClient dbClient, UserSession userSession, ComponentUpdater componentUpdater) {
        this.support = support;
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.componentUpdater = componentUpdater;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("create").setDescription("Create a project.<br/>Requires 'Create Projects' permission").setSince("4.0").setPost(true).setResponseExample(this.getClass().getResource("create-example.json")).setHandler((RequestHandler)this);
        action.setChangelog(new Change[]{new Change("6.3", "The response format has been updated and does not contain the database ID anymore"), new Change("6.3", "The 'key' parameter has been renamed 'project'"), new Change("7.1", "The 'visibility' parameter is public")});
        action.createParam("project").setDescription("Key of the project").setDeprecatedKey(DEPRECATED_PARAM_KEY, "6.3").setRequired(true).setMaximumLength(Integer.valueOf(400)).setExampleValue((Object)"my_project");
        action.createParam("name").setDescription("Name of the project. If name is longer than %d, it is abbreviated.", new Object[]{500}).setRequired(true).setExampleValue((Object)"SonarQube");
        action.createParam("branch").setDescription("SCM Branch of the project. The key of the project will become key:branch, for instance 'SonarQube:branch-5.0'").setExampleValue((Object)"branch-5.0");
        action.createParam("visibility").setDescription("Whether the created project should be visible to everyone, or only specific user/groups.<br/>If no visibility is specified, the default project visibility of the organization will be used.").setRequired(false).setSince("6.4").setPossibleValues(Visibility.getLabels());
        this.support.addOrganizationParam(action);
    }

    public void handle(Request request, Response response) throws Exception {
        CreateRequest createRequest = CreateAction.toCreateRequest(request);
        WsUtils.writeProtobuf((Message)this.doHandle(createRequest), request, response);
    }

    private Projects.CreateWsResponse doHandle(CreateRequest request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organization = this.support.getOrganization(dbSession, request.getOrganization());
            this.userSession.checkPermission(OrganizationPermission.PROVISION_PROJECTS, organization);
            String visibility = request.getVisibility();
            boolean changeToPrivate = visibility == null ? this.dbClient.organizationDao().getNewProjectPrivate(dbSession, organization) : "private".equals(visibility);
            this.support.checkCanUpdateProjectsVisibility(organization, changeToPrivate);
            ComponentDto componentDto = this.componentUpdater.create(dbSession, NewComponent.newComponentBuilder().setOrganizationUuid(organization.getUuid()).setKey(request.getKey()).setName(request.getName()).setDeprecatedBranch(request.getBranch()).setPrivate(changeToPrivate).setQualifier("TRK").build(), this.userSession.isLoggedIn() ? this.userSession.getUserId() : null);
            Projects.CreateWsResponse createWsResponse = CreateAction.toCreateResponse(componentDto);
            return createWsResponse;
        }
    }

    private static CreateRequest toCreateRequest(Request request) {
        return CreateRequest.builder().setOrganization(request.param("organization")).setKey(request.mandatoryParam("project")).setName(StringUtils.abbreviate((String)request.mandatoryParam("name"), (int)500)).setBranch(request.param("branch")).setVisibility(request.param("visibility")).build();
    }

    private static Projects.CreateWsResponse toCreateResponse(ComponentDto componentDto) {
        return Projects.CreateWsResponse.newBuilder().setProject(Projects.CreateWsResponse.Project.newBuilder().setKey(componentDto.getDbKey()).setName(componentDto.name()).setQualifier(componentDto.qualifier()).setVisibility(Visibility.getLabel(componentDto.isPrivate()))).build();
    }

    static class Builder {
        private String organization;
        private String key;
        private String name;
        private String branch;
        @CheckForNull
        private String visibility;

        private Builder() {
        }

        public Builder setOrganization(@Nullable String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setKey(@Nullable String key) {
            this.key = key;
            return this;
        }

        public Builder setName(@Nullable String name) {
            this.name = name;
            return this;
        }

        public Builder setBranch(@Nullable String branch) {
            this.branch = branch;
            return this;
        }

        public Builder setVisibility(@Nullable String visibility) {
            this.visibility = visibility;
            return this;
        }

        public CreateRequest build() {
            return new CreateRequest(this);
        }
    }

    static class CreateRequest {
        private final String organization;
        private final String key;
        private final String name;
        private final String branch;
        @CheckForNull
        private final String visibility;

        private CreateRequest(Builder builder) {
            this.organization = builder.organization;
            this.key = builder.key;
            this.name = builder.name;
            this.branch = builder.branch;
            this.visibility = builder.visibility;
        }

        @CheckForNull
        public String getOrganization() {
            return this.organization;
        }

        @CheckForNull
        public String getKey() {
            return this.key;
        }

        @CheckForNull
        public String getName() {
            return this.name;
        }

        @CheckForNull
        public String getBranch() {
            return this.branch;
        }

        @CheckForNull
        public String getVisibility() {
            return this.visibility;
        }

        public static Builder builder() {
            return new Builder();
        }
    }
}

