/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.projectanalysis.ws;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.System2;
import org.sonar.core.util.UuidFactory;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.SnapshotDto;
import org.sonar.db.event.EventDto;
import org.sonar.server.exceptions.NotFoundException;
import org.sonar.server.projectanalysis.ws.EventCategory;
import org.sonar.server.projectanalysis.ws.EventValidator;
import org.sonar.server.projectanalysis.ws.ProjectAnalysesWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.ProjectAnalyses;

public class CreateEventAction
implements ProjectAnalysesWsAction {
    private static final Set<String> ALLOWED_QUALIFIERS = ImmutableSet.of((Object)"TRK", (Object)"APP");
    private final DbClient dbClient;
    private final UuidFactory uuidFactory;
    private final System2 system;
    private final UserSession userSession;

    public CreateEventAction(DbClient dbClient, UuidFactory uuidFactory, System2 system, UserSession userSession) {
        this.dbClient = dbClient;
        this.uuidFactory = uuidFactory;
        this.system = system;
        this.userSession = userSession;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("create_event").setDescription("Create a project analysis event.<br>Only event of category '%s' and '%s' can be created.<br>Requires one of the following permissions:<ul>  <li>'Administer System'</li>  <li>'Administer' rights on the specified project</li></ul>", new Object[]{EventCategory.VERSION.name(), EventCategory.OTHER.name()}).setSince("6.3").setPost(true).setResponseExample(this.getClass().getResource("create_event-example.json")).setHandler((RequestHandler)this);
        action.createParam("analysis").setDescription("Analysis key").setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy").setRequired(true);
        action.createParam("category").setDescription("Category").setDefaultValue((Object)EventCategory.OTHER).setPossibleValues((Object[])new EventCategory[]{EventCategory.VERSION, EventCategory.OTHER});
        action.createParam("name").setRequired(true).setMaximumLength(Integer.valueOf(400)).setDescription("Name").setExampleValue((Object)"5.6");
    }

    public void handle(Request httpRequest, Response httpResponse) throws Exception {
        CreateEventRequest request = CreateEventAction.toAddEventRequest(httpRequest);
        ProjectAnalyses.CreateEventResponse response = this.doHandle(request);
        WsUtils.writeProtobuf((Message)response, httpRequest, httpResponse);
    }

    private ProjectAnalyses.CreateEventResponse doHandle(CreateEventRequest request) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            SnapshotDto analysis = this.getAnalysis(dbSession, request);
            ComponentDto project = this.getProjectOrApplication(dbSession, analysis);
            this.checkRequest(request, project);
            this.checkExistingDbEvents(dbSession, request, analysis);
            EventDto dbEvent = this.insertDbEvent(dbSession, request, analysis);
            ProjectAnalyses.CreateEventResponse createEventResponse = CreateEventAction.toCreateEventResponse(dbEvent);
            return createEventResponse;
        }
    }

    private EventDto insertDbEvent(DbSession dbSession, CreateEventRequest request, SnapshotDto analysis) {
        EventDto dbEvent = this.dbClient.eventDao().insert(dbSession, this.toDbEvent(request, analysis));
        if (EventCategory.VERSION.equals((Object)request.getCategory())) {
            analysis.setProjectVersion(request.getName());
            this.dbClient.snapshotDao().update(dbSession, analysis);
        }
        dbSession.commit();
        return dbEvent;
    }

    private SnapshotDto getAnalysis(DbSession dbSession, CreateEventRequest request) {
        return (SnapshotDto)this.dbClient.snapshotDao().selectByUuid(dbSession, request.getAnalysis()).orElseThrow(() -> new NotFoundException(String.format("Analysis '%s' is not found", request.getAnalysis())));
    }

    private ComponentDto getProjectOrApplication(DbSession dbSession, SnapshotDto analysis) {
        ComponentDto project = this.dbClient.componentDao().selectByUuid(dbSession, analysis.getComponentUuid()).orElse(null);
        Preconditions.checkState((project != null ? 1 : 0) != 0, (String)"Project of analysis '%s' is not found", (Object[])new Object[]{analysis.getUuid()});
        Preconditions.checkArgument((ALLOWED_QUALIFIERS.contains(project.qualifier()) && "PRJ".equals(project.scope()) ? 1 : 0) != 0, (Object)"An event must be created on a project or an application");
        return project;
    }

    private void checkRequest(CreateEventRequest request, ComponentDto component) {
        this.userSession.checkComponentPermission("admin", component);
        Preconditions.checkArgument((EventCategory.VERSION != request.getCategory() || "TRK".equals(component.qualifier()) ? 1 : 0) != 0, (Object)"A version event must be created on a project");
        EventValidator.checkVersionName(request.getCategory(), request.getName());
    }

    private static CreateEventRequest toAddEventRequest(Request request) {
        return CreateEventRequest.builder().setAnalysis(request.mandatoryParam("analysis")).setName(request.mandatoryParam("name")).setCategory((EventCategory)request.mandatoryParamAsEnum("category", EventCategory.class)).build();
    }

    private EventDto toDbEvent(CreateEventRequest request, SnapshotDto analysis) {
        return new EventDto().setUuid(this.uuidFactory.create()).setAnalysisUuid(analysis.getUuid()).setComponentUuid(analysis.getComponentUuid()).setCategory(request.getCategory().getLabel()).setName(request.getName()).setCreatedAt(Long.valueOf(this.system.now())).setDate(analysis.getCreatedAt());
    }

    private static ProjectAnalyses.CreateEventResponse toCreateEventResponse(EventDto dbEvent) {
        ProjectAnalyses.Event.Builder wsEvent = ProjectAnalyses.Event.newBuilder().setKey(dbEvent.getUuid()).setCategory(EventCategory.fromLabel(dbEvent.getCategory()).name()).setAnalysis(dbEvent.getAnalysisUuid()).setName(dbEvent.getName());
        Optional.ofNullable(dbEvent.getDescription()).ifPresent(arg_0 -> ((ProjectAnalyses.Event.Builder)wsEvent).setDescription(arg_0));
        return ProjectAnalyses.CreateEventResponse.newBuilder().setEvent(wsEvent).build();
    }

    private void checkExistingDbEvents(DbSession dbSession, CreateEventRequest request, SnapshotDto analysis) {
        List dbEvents = this.dbClient.eventDao().selectByAnalysisUuid(dbSession, analysis.getUuid());
        Predicate<EventDto> similarEventExisting = CreateEventAction.filterSimilarEvents(request);
        dbEvents.stream().filter(similarEventExisting).findAny().ifPresent(CreateEventAction.throwException(request));
    }

    private static Predicate<EventDto> filterSimilarEvents(CreateEventRequest request) {
        switch (request.getCategory()) {
            case VERSION: {
                return dbEvent -> EventCategory.VERSION.getLabel().equals(dbEvent.getCategory());
            }
            case OTHER: {
                return dbEvent -> EventCategory.OTHER.getLabel().equals(dbEvent.getCategory()) && request.getName().equals(dbEvent.getName());
            }
        }
        throw new IllegalStateException("Event category not handled: " + (Object)((Object)request.getCategory()));
    }

    private static Consumer<EventDto> throwException(CreateEventRequest request) {
        switch (request.getCategory()) {
            case VERSION: {
                return dbEvent -> {
                    throw new IllegalArgumentException(String.format("A version event already exists on analysis '%s'", request.getAnalysis()));
                };
            }
            case OTHER: {
                return dbEvent -> {
                    throw new IllegalArgumentException(String.format("An '%s' event with the same name already exists on analysis '%s'", EventCategory.OTHER.getLabel(), request.getAnalysis()));
                };
            }
        }
        throw new IllegalStateException("Event category not handled: " + (Object)((Object)request.getCategory()));
    }

    private static class Builder {
        private String analysis;
        private EventCategory category = EventCategory.OTHER;
        private String name;

        private Builder() {
        }

        public Builder setAnalysis(String analysis) {
            this.analysis = analysis;
            return this;
        }

        public Builder setCategory(EventCategory category) {
            this.category = category;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public CreateEventRequest build() {
            Preconditions.checkArgument((this.analysis != null ? 1 : 0) != 0, (Object)"Analysis key is required");
            Preconditions.checkArgument((this.category != null ? 1 : 0) != 0, (Object)"Category is required");
            Preconditions.checkArgument((this.name != null ? 1 : 0) != 0, (Object)"Name is required");
            return new CreateEventRequest(this);
        }
    }

    private static class CreateEventRequest {
        private final String analysis;
        private final EventCategory category;
        private final String name;

        private CreateEventRequest(Builder builder) {
            this.analysis = builder.analysis;
            this.category = builder.category;
            this.name = builder.name;
        }

        public String getAnalysis() {
            return this.analysis;
        }

        public EventCategory getCategory() {
            return this.category;
        }

        public String getName() {
            return this.name;
        }

        public static Builder builder() {
            return new Builder();
        }
    }
}

