/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.projectanalysis.ws;

import com.google.common.collect.ListMultimap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.utils.Paging;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.SnapshotDto;
import org.sonar.db.event.EventComponentChangeDto;
import org.sonar.db.event.EventDto;
import org.sonar.server.projectanalysis.ws.SearchRequest;

class SearchData {
    final List<SnapshotDto> analyses;
    final ListMultimap<String, EventDto> eventsByAnalysis;
    final ListMultimap<String, EventComponentChangeDto> componentChangesByEventUuid;
    final Paging paging;
    @CheckForNull
    private final String manualBaseline;

    private SearchData(Builder builder) {
        this.analyses = builder.analyses;
        this.eventsByAnalysis = SearchData.buildEvents(builder.events);
        this.componentChangesByEventUuid = SearchData.buildComponentChanges(builder.componentChanges);
        this.paging = Paging.forPageIndex((int)builder.getRequest().getPage()).withPageSize(builder.getRequest().getPageSize()).andTotal(builder.countAnalyses);
        this.manualBaseline = builder.manualBaseline;
    }

    private static ListMultimap<String, EventDto> buildEvents(List<EventDto> events) {
        return (ListMultimap)events.stream().collect(MoreCollectors.index(EventDto::getAnalysisUuid));
    }

    private static ListMultimap<String, EventComponentChangeDto> buildComponentChanges(List<EventComponentChangeDto> changes) {
        return (ListMultimap)changes.stream().collect(MoreCollectors.index(EventComponentChangeDto::getEventUuid));
    }

    static Builder builder(DbSession dbSession, SearchRequest request) {
        return new Builder(dbSession, request);
    }

    public Optional<String> getManualBaseline() {
        return Optional.ofNullable(this.manualBaseline);
    }

    static class Builder {
        private final DbSession dbSession;
        private final SearchRequest request;
        private ComponentDto project;
        private List<SnapshotDto> analyses;
        private int countAnalyses;
        private String manualBaseline;
        private List<EventDto> events;
        private List<EventComponentChangeDto> componentChanges;

        private Builder(DbSession dbSession, SearchRequest request) {
            this.dbSession = dbSession;
            this.request = request;
        }

        Builder setProject(ComponentDto project) {
            this.project = project;
            return this;
        }

        Builder setAnalyses(List<SnapshotDto> analyses) {
            Stream stream = analyses.stream();
            if (this.request.getCategory() == null) {
                stream = stream.skip(Paging.offset((int)this.request.getPage(), (int)this.request.getPageSize())).limit(this.request.getPageSize());
            }
            this.analyses = (List)stream.collect(MoreCollectors.toList());
            this.countAnalyses = analyses.size();
            return this;
        }

        Builder setEvents(List<EventDto> events) {
            this.events = events;
            return this;
        }

        public List<EventComponentChangeDto> getComponentChanges() {
            return this.componentChanges;
        }

        Builder setComponentChanges(List<EventComponentChangeDto> componentChanges) {
            this.componentChanges = componentChanges;
            return this;
        }

        DbSession getDbSession() {
            return this.dbSession;
        }

        SearchRequest getRequest() {
            return this.request;
        }

        ComponentDto getProject() {
            return this.project;
        }

        List<SnapshotDto> getAnalyses() {
            return this.analyses;
        }

        public Builder setManualBaseline(@Nullable String manualBaseline) {
            this.manualBaseline = manualBaseline;
            return this;
        }

        private void filterByCategory() {
            ListMultimap eventCategoriesByAnalysisUuid = (ListMultimap)this.events.stream().collect(MoreCollectors.index(EventDto::getAnalysisUuid, EventDto::getCategory));
            Predicate<SnapshotDto> byCategory = a -> eventCategoriesByAnalysisUuid.get((Object)a.getUuid()).contains(this.request.getCategory().getLabel());
            this.countAnalyses = (int)this.analyses.stream().filter(byCategory).count();
            this.analyses = (List)this.analyses.stream().filter(byCategory).skip(Paging.offset((int)this.request.getPage(), (int)this.request.getPageSize())).limit(this.request.getPageSize()).collect(MoreCollectors.toList());
        }

        SearchData build() {
            Objects.requireNonNull(this.analyses);
            Objects.requireNonNull(this.events);
            if (this.request.getCategory() != null) {
                this.filterByCategory();
            }
            return new SearchData(this);
        }
    }
}

