/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.projectlink.ws;

import com.google.protobuf.Message;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.Slug;
import org.sonar.core.util.UuidFactory;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.ProjectLinkDto;
import org.sonar.server.component.ComponentFinder;
import org.sonar.server.projectlink.ws.ProjectLinksWs;
import org.sonar.server.projectlink.ws.ProjectLinksWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.ProjectLinks;

public class CreateAction
implements ProjectLinksWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final ComponentFinder componentFinder;
    private final UuidFactory uuidFactory;
    private static final int LINK_NAME_MAX_LENGTH = 128;
    private static final int LINK_URL_MAX_LENGTH = 2048;
    private static final int LINK_TYPE_MAX_LENGTH = 20;

    public CreateAction(DbClient dbClient, UserSession userSession, ComponentFinder componentFinder, UuidFactory uuidFactory) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.componentFinder = componentFinder;
        this.uuidFactory = uuidFactory;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("create").setDescription("Create a new project link.<br>Requires 'Administer' permission on the specified project, or global 'Administer' permission.").setHandler((RequestHandler)this).setPost(true).setResponseExample(this.getClass().getResource("create-example.json")).setSince("6.1");
        action.createParam("projectId").setDescription("Project id").setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy");
        action.createParam("projectKey").setDescription("Project key").setExampleValue((Object)"my_project");
        action.createParam("name").setRequired(true).setMaximumLength(Integer.valueOf(128)).setDescription("Link name").setExampleValue((Object)"Custom");
        action.createParam("url").setRequired(true).setMaximumLength(Integer.valueOf(2048)).setDescription("Link url").setExampleValue((Object)"http://example.com");
    }

    public void handle(Request request, Response response) throws Exception {
        CreateRequest searchWsRequest = CreateAction.toCreateWsRequest(request);
        ProjectLinks.CreateWsResponse createWsResponse = this.doHandle(searchWsRequest);
        WsUtils.writeProtobuf((Message)createWsResponse, request, response);
    }

    private ProjectLinks.CreateWsResponse doHandle(CreateRequest createWsRequest) {
        String name = createWsRequest.getName();
        String url = createWsRequest.getUrl();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ComponentDto component = ProjectLinksWs.checkProject(this.getComponentByUuidOrKey(dbSession, createWsRequest));
            this.userSession.checkComponentPermission("admin", component);
            ProjectLinkDto link = new ProjectLinkDto().setUuid(this.uuidFactory.create()).setProjectUuid(component.uuid()).setName(name).setHref(url).setType(CreateAction.nameToType(name));
            this.dbClient.projectLinkDao().insert(dbSession, link);
            dbSession.commit();
            ProjectLinks.CreateWsResponse createWsResponse = CreateAction.buildResponse(link);
            return createWsResponse;
        }
    }

    private static ProjectLinks.CreateWsResponse buildResponse(ProjectLinkDto link) {
        return ProjectLinks.CreateWsResponse.newBuilder().setLink(ProjectLinks.Link.newBuilder().setId(String.valueOf(link.getUuid())).setName(link.getName()).setType(link.getType()).setUrl(link.getHref())).build();
    }

    private ComponentDto getComponentByUuidOrKey(DbSession dbSession, CreateRequest request) {
        return this.componentFinder.getByUuidOrKey(dbSession, request.getProjectId(), request.getProjectKey(), ComponentFinder.ParamNames.PROJECT_ID_AND_KEY);
    }

    private static CreateRequest toCreateWsRequest(Request request) {
        return new CreateRequest().setProjectId(request.param("projectId")).setProjectKey(request.param("projectKey")).setName(request.mandatoryParam("name")).setUrl(request.mandatoryParam("url"));
    }

    private static String nameToType(String name) {
        String slugified = Slug.slugify((String)name);
        return slugified.substring(0, Math.min(slugified.length(), 20));
    }

    private static class CreateRequest {
        private String name;
        private String projectId;
        private String projectKey;
        private String url;

        private CreateRequest() {
        }

        public CreateRequest setName(String name) {
            this.name = name;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public CreateRequest setProjectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public CreateRequest setProjectKey(String projectKey) {
            this.projectKey = projectKey;
            return this;
        }

        public String getProjectKey() {
            return this.projectKey;
        }

        public CreateRequest setUrl(String url) {
            this.url = url;
            return this;
        }

        public String getUrl() {
            return this.url;
        }
    }
}

