/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.api.measures.Metric;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.metric.MetricDto;
import org.sonar.db.qualitygate.QualityGateConditionDto;
import org.sonar.db.qualitygate.QualityGateDto;
import org.sonar.server.exceptions.NotFoundException;
import org.sonar.server.measure.Rating;
import org.sonar.server.qualitygate.Condition;
import org.sonar.server.qualitygate.ValidRatingMetrics;
import org.sonar.server.ws.WsUtils;

public class QualityGateConditionsUpdater {
    private static final Map<Integer, ImmutableSet<Condition.Operator>> VALID_OPERATORS_BY_DIRECTION = ImmutableMap.builder().put((Object)0, (Object)ImmutableSet.of((Object)Condition.Operator.GREATER_THAN, (Object)Condition.Operator.LESS_THAN)).put((Object)1, (Object)ImmutableSet.of((Object)Condition.Operator.LESS_THAN)).put((Object)-1, (Object)ImmutableSet.of((Object)Condition.Operator.GREATER_THAN)).build();
    private static final EnumSet<Metric.ValueType> VALID_METRIC_TYPES = EnumSet.of(Metric.ValueType.INT, new Metric.ValueType[]{Metric.ValueType.FLOAT, Metric.ValueType.PERCENT, Metric.ValueType.MILLISEC, Metric.ValueType.LEVEL, Metric.ValueType.RATING, Metric.ValueType.WORK_DUR});
    private static final List<String> RATING_VALID_INT_VALUES = Arrays.stream(Rating.values()).map(r -> Integer.toString(r.getIndex())).collect(Collectors.toList());
    private final DbClient dbClient;

    public QualityGateConditionsUpdater(DbClient dbClient) {
        this.dbClient = dbClient;
    }

    public QualityGateConditionDto createCondition(DbSession dbSession, QualityGateDto qualityGate, String metricKey, String operator, String errorThreshold) {
        MetricDto metric = this.getNonNullMetric(dbSession, metricKey);
        QualityGateConditionsUpdater.validateCondition(metric, operator, errorThreshold);
        QualityGateConditionsUpdater.checkConditionDoesNotExistOnSameMetric(this.getConditions(dbSession, qualityGate.getId()), metric);
        QualityGateConditionDto newCondition = new QualityGateConditionDto().setQualityGateId(qualityGate.getId().longValue()).setMetricId((long)metric.getId().intValue()).setMetricKey(metric.getKey()).setOperator(operator).setErrorThreshold(errorThreshold);
        this.dbClient.gateConditionDao().insert(newCondition, dbSession);
        return newCondition;
    }

    public QualityGateConditionDto updateCondition(DbSession dbSession, QualityGateConditionDto condition, String metricKey, String operator, String errorThreshold) {
        MetricDto metric = this.getNonNullMetric(dbSession, metricKey);
        QualityGateConditionsUpdater.validateCondition(metric, operator, errorThreshold);
        condition.setMetricId((long)metric.getId().intValue()).setMetricKey(metric.getKey()).setOperator(operator).setErrorThreshold(errorThreshold);
        this.dbClient.gateConditionDao().update(condition, dbSession);
        return condition;
    }

    private MetricDto getNonNullMetric(DbSession dbSession, String metricKey) {
        MetricDto metric = this.dbClient.metricDao().selectByKey(dbSession, metricKey);
        if (metric == null) {
            throw new NotFoundException(String.format("There is no metric with key=%s", metricKey));
        }
        return metric;
    }

    private Collection<QualityGateConditionDto> getConditions(DbSession dbSession, long qGateId) {
        return this.dbClient.gateConditionDao().selectForQualityGate(dbSession, qGateId);
    }

    private static void validateCondition(MetricDto metric, String operator, String errorThreshold) {
        ArrayList<String> errors = new ArrayList<String>();
        QualityGateConditionsUpdater.validateMetric(metric, errors);
        QualityGateConditionsUpdater.checkOperator(metric, operator, errors);
        QualityGateConditionsUpdater.checkErrorThreshold(metric, errorThreshold, errors);
        QualityGateConditionsUpdater.checkRatingMetric(metric, errorThreshold, errors);
        WsUtils.checkRequest(errors.isEmpty(), errors);
    }

    private static void validateMetric(MetricDto metric, List<String> errors) {
        QualityGateConditionsUpdater.check(QualityGateConditionsUpdater.isAlertable(metric), errors, "Metric '%s' cannot be used to define a condition.", metric.getKey());
    }

    private static boolean isAlertable(MetricDto metric) {
        return !metric.isHidden() && VALID_METRIC_TYPES.contains(Metric.ValueType.valueOf((String)metric.getValueType())) && !"alert_status".equals(metric.getKey());
    }

    private static void checkOperator(MetricDto metric, String operator, List<String> errors) {
        QualityGateConditionsUpdater.check(Condition.Operator.isValid((String)operator) && QualityGateConditionsUpdater.isAllowedOperator(operator, metric), errors, "Operator %s is not allowed for this metric.", operator);
    }

    private static void checkErrorThreshold(MetricDto metric, String errorThreshold, List<String> errors) {
        Objects.requireNonNull(errorThreshold, "errorThreshold can not be null");
        QualityGateConditionsUpdater.validateErrorThresholdValue(metric, errorThreshold, errors);
    }

    private static void checkConditionDoesNotExistOnSameMetric(Collection<QualityGateConditionDto> conditions, MetricDto metric) {
        if (conditions.isEmpty()) {
            return;
        }
        boolean conditionExists = conditions.stream().anyMatch(c -> c.getMetricId() == (long)metric.getId().intValue());
        WsUtils.checkRequest(!conditionExists, String.format("Condition on metric '%s' already exists.", metric.getShortName()), new Object[0]);
    }

    private static boolean isAllowedOperator(String operator, MetricDto metric) {
        if (VALID_OPERATORS_BY_DIRECTION.containsKey(metric.getDirection())) {
            return VALID_OPERATORS_BY_DIRECTION.get(metric.getDirection()).contains((Object)Condition.Operator.fromDbValue((String)operator));
        }
        return false;
    }

    private static void validateErrorThresholdValue(MetricDto metric, String errorThreshold, List<String> errors) {
        try {
            Metric.ValueType valueType = Metric.ValueType.valueOf((String)metric.getValueType());
            switch (valueType) {
                case BOOL: 
                case INT: 
                case RATING: {
                    Integer.parseInt(errorThreshold);
                    return;
                }
                case MILLISEC: 
                case WORK_DUR: {
                    Long.parseLong(errorThreshold);
                    return;
                }
                case FLOAT: 
                case PERCENT: {
                    Double.parseDouble(errorThreshold);
                    return;
                }
                case STRING: 
                case LEVEL: {
                    return;
                }
            }
            throw new IllegalArgumentException(String.format("Unsupported value type %s. Cannot convert condition value", valueType));
        }
        catch (Exception e) {
            errors.add(String.format("Invalid value '%s' for metric '%s'", errorThreshold, metric.getShortName()));
            return;
        }
    }

    private static void checkRatingMetric(MetricDto metric, String errorThreshold, List<String> errors) {
        if (!metric.getValueType().equals(Metric.ValueType.RATING.name())) {
            return;
        }
        if (!ValidRatingMetrics.isCoreRatingMetric(metric.getKey())) {
            errors.add(String.format("The metric '%s' cannot be used", metric.getShortName()));
        }
        if (!QualityGateConditionsUpdater.isValidRating(errorThreshold)) {
            QualityGateConditionsUpdater.addInvalidRatingError(errorThreshold, errors);
            return;
        }
        QualityGateConditionsUpdater.checkRatingGreaterThanOperator(errorThreshold, errors);
    }

    private static void addInvalidRatingError(@Nullable String value, List<String> errors) {
        errors.add(String.format("'%s' is not a valid rating", value));
    }

    private static void checkRatingGreaterThanOperator(@Nullable String value, List<String> errors) {
        QualityGateConditionsUpdater.check(Strings.isNullOrEmpty((String)value) || !Objects.equals(QualityGateConditionsUpdater.toRating(value), Rating.E), errors, "There's no worse rating than E (%s)", value);
    }

    private static Rating toRating(String value) {
        return Rating.valueOf((int)Integer.parseInt(value));
    }

    private static boolean isValidRating(@Nullable String value) {
        return Strings.isNullOrEmpty((String)value) || RATING_VALID_INT_VALUES.contains(value);
    }

    private static boolean check(boolean expression, List<String> errors, String message, String ... args) {
        if (!expression) {
            errors.add(String.format(message, args));
        }
        return expression;
    }
}

