/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate.changeevent;

import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.sonar.api.rules.RuleType;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.server.qualitygate.changeevent.QGChangeEvent;
import org.sonar.server.qualitygate.changeevent.QGChangeEventListener;
import org.sonar.server.qualitygate.changeevent.QGChangeEventListeners;

public class QGChangeEventListenersImpl
implements QGChangeEventListeners {
    private static final Logger LOG = Loggers.get(QGChangeEventListenersImpl.class);
    private final QGChangeEventListener[] listeners;

    public QGChangeEventListenersImpl() {
        this.listeners = new QGChangeEventListener[0];
    }

    public QGChangeEventListenersImpl(QGChangeEventListener[] listeners) {
        this.listeners = listeners;
    }

    @Override
    public void broadcastOnIssueChange(List<DefaultIssue> issues, Collection<QGChangeEvent> changeEvents) {
        if (this.listeners.length == 0 || issues.isEmpty() || changeEvents.isEmpty()) {
            return;
        }
        try {
            Multimap eventsByComponentUuid = (Multimap)changeEvents.stream().collect(MoreCollectors.index(t -> t.getProject().uuid()));
            Multimap issueByComponentUuid = (Multimap)issues.stream().collect(MoreCollectors.index(DefaultIssue::projectUuid));
            issueByComponentUuid.asMap().forEach((componentUuid, value) -> {
                Collection qgChangeEvents = eventsByComponentUuid.get(componentUuid);
                if (!qgChangeEvents.isEmpty()) {
                    Set changedIssues = (Set)value.stream().map(ChangedIssueImpl::new).collect(MoreCollectors.toSet());
                    qgChangeEvents.forEach(changeEvent -> Arrays.stream(this.listeners).forEach(listener -> QGChangeEventListenersImpl.broadcastTo(changedIssues, changeEvent, listener)));
                }
            });
        }
        catch (Error e) {
            LOG.warn(String.format("Broadcasting to listeners failed for %s events", changeEvents.size()), (Throwable)e);
        }
    }

    private static void broadcastTo(Set<QGChangeEventListener.ChangedIssue> changedIssues, QGChangeEvent changeEvent, QGChangeEventListener listener) {
        try {
            LOG.trace("calling onChange() on listener {} for events {}...", (Object)listener.getClass().getName(), (Object)changeEvent);
            listener.onIssueChanges(changeEvent, changedIssues);
        }
        catch (Exception e) {
            LOG.warn(String.format("onChange() call failed on listener %s for events %s", listener.getClass().getName(), changeEvent), (Throwable)e);
        }
    }

    static class ChangedIssueImpl
    implements QGChangeEventListener.ChangedIssue {
        private final String key;
        private final QGChangeEventListener.Status status;
        private final RuleType type;
        private final String severity;

        ChangedIssueImpl(DefaultIssue issue) {
            this.key = issue.key();
            this.status = ChangedIssueImpl.statusOf(issue);
            this.type = issue.type();
            this.severity = issue.severity();
        }

        static QGChangeEventListener.Status statusOf(DefaultIssue issue) {
            switch (issue.status()) {
                case "OPEN": {
                    return QGChangeEventListener.Status.OPEN;
                }
                case "CONFIRMED": {
                    return QGChangeEventListener.Status.CONFIRMED;
                }
                case "REOPENED": {
                    return QGChangeEventListener.Status.REOPENED;
                }
                case "RESOLVED": {
                    return ChangedIssueImpl.statusOfResolved(issue);
                }
            }
            throw new IllegalStateException("Unexpected status: " + issue.status());
        }

        private static QGChangeEventListener.Status statusOfResolved(DefaultIssue issue) {
            String resolution = issue.resolution();
            Objects.requireNonNull(resolution, "A resolved issue should have a resolution");
            switch (resolution) {
                case "FALSE-POSITIVE": {
                    return QGChangeEventListener.Status.RESOLVED_FP;
                }
                case "WONTFIX": {
                    return QGChangeEventListener.Status.RESOLVED_WF;
                }
                case "FIXED": {
                    return QGChangeEventListener.Status.RESOLVED_FIXED;
                }
            }
            throw new IllegalStateException("Unexpected resolution for a resolved issue: " + resolution);
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public QGChangeEventListener.Status getStatus() {
            return this.status;
        }

        @Override
        public RuleType getType() {
            return this.type;
        }

        @Override
        public String getSeverity() {
            return this.severity;
        }

        public String toString() {
            return "ChangedIssueImpl{key='" + this.key + '\'' + ", status=" + (Object)((Object)this.status) + ", type=" + this.type + ", severity=" + this.severity + '}';
        }
    }
}

