/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate.ws;

import com.google.common.base.Preconditions;
import com.google.common.io.Resources;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.metric.MetricDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualitygate.QualityGateConditionDto;
import org.sonar.db.qualitygate.QualityGateDto;
import org.sonar.server.qualitygate.QualityGateFinder;
import org.sonar.server.qualitygate.ws.QualityGatesWsAction;
import org.sonar.server.qualitygate.ws.QualityGatesWsSupport;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Qualitygates;

public class ShowAction
implements QualityGatesWsAction {
    private final DbClient dbClient;
    private final QualityGateFinder qualityGateFinder;
    private final QualityGatesWsSupport wsSupport;

    public ShowAction(DbClient dbClient, QualityGateFinder qualityGateFinder, QualityGatesWsSupport wsSupport) {
        this.dbClient = dbClient;
        this.qualityGateFinder = qualityGateFinder;
        this.wsSupport = wsSupport;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("show").setDescription("Display the details of a quality gate").setSince("4.3").setResponseExample(Resources.getResource(this.getClass(), (String)"show-example.json")).setChangelog(new Change[]{new Change("7.6", "'period' and 'warning' fields of conditions are removed from the response"), new Change("7.0", "'isBuiltIn' field is added to the response"), new Change("7.0", "'actions' field is added in the response")}).setHandler((RequestHandler)this);
        action.createParam("id").setDescription("ID of the quality gate. Either id or name must be set").setExampleValue((Object)"1");
        action.createParam("name").setDescription("Name of the quality gate. Either id or name must be set").setExampleValue((Object)"My Quality Gate");
        this.wsSupport.createOrganizationParam(action);
    }

    public void handle(Request request, Response response) {
        Long id = request.paramAsLong("id");
        String name = request.param("name");
        ShowAction.checkOneOfIdOrNamePresent(id, name);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organization = this.wsSupport.getOrganization(dbSession, request);
            QualityGateDto qualityGate = this.getByNameOrId(dbSession, organization, name, id);
            Collection<QualityGateConditionDto> conditions = this.getConditions(dbSession, qualityGate);
            Map<Integer, MetricDto> metricsById = this.getMetricsById(dbSession, conditions);
            QualityGateDto defaultQualityGate = this.qualityGateFinder.getDefault(dbSession, organization);
            WsUtils.writeProtobuf((Message)this.buildResponse(organization, qualityGate, defaultQualityGate, conditions, metricsById), request, response);
        }
    }

    private QualityGateDto getByNameOrId(DbSession dbSession, OrganizationDto organization, @Nullable String name, @Nullable Long id) {
        if (name != null) {
            return (QualityGateDto)WsUtils.checkFound(this.dbClient.qualityGateDao().selectByOrganizationAndName(dbSession, organization, name), "No quality gate has been found for name %s", name);
        }
        if (id != null) {
            return this.wsSupport.getByOrganizationAndId(dbSession, organization, id);
        }
        throw new IllegalArgumentException("No parameter has been set to identify a quality gate");
    }

    public Collection<QualityGateConditionDto> getConditions(DbSession dbSession, QualityGateDto qualityGate) {
        return this.dbClient.gateConditionDao().selectForQualityGate(dbSession, qualityGate.getId().longValue());
    }

    private Map<Integer, MetricDto> getMetricsById(DbSession dbSession, Collection<QualityGateConditionDto> conditions) {
        Set metricIds = (Set)conditions.stream().map(c -> (int)c.getMetricId()).collect(MoreCollectors.toSet());
        return (Map)this.dbClient.metricDao().selectByIds(dbSession, metricIds).stream().filter(MetricDto::isEnabled).collect(MoreCollectors.uniqueIndex(MetricDto::getId));
    }

    private Qualitygates.ShowWsResponse buildResponse(OrganizationDto organization, QualityGateDto qualityGate, QualityGateDto defaultQualityGate, Collection<QualityGateConditionDto> conditions, Map<Integer, MetricDto> metricsById) {
        return Qualitygates.ShowWsResponse.newBuilder().setId(qualityGate.getId().longValue()).setName(qualityGate.getName()).setIsBuiltIn(qualityGate.isBuiltIn()).addAllConditions((Iterable)conditions.stream().map(ShowAction.toWsCondition(metricsById)).collect(MoreCollectors.toList())).setActions(this.wsSupport.getActions(organization, qualityGate, defaultQualityGate)).build();
    }

    private static Function<QualityGateConditionDto, Qualitygates.ShowWsResponse.Condition> toWsCondition(Map<Integer, MetricDto> metricsById) {
        return condition -> {
            int metricId = (int)condition.getMetricId();
            MetricDto metric = (MetricDto)metricsById.get(metricId);
            Preconditions.checkState((metric != null ? 1 : 0) != 0, (String)"Could not find metric with id %s", (Object[])new Object[]{metricId});
            Qualitygates.ShowWsResponse.Condition.Builder builder = Qualitygates.ShowWsResponse.Condition.newBuilder().setId(condition.getId()).setMetric(metric.getKey()).setOp(condition.getOperator());
            Optional.ofNullable(condition.getErrorThreshold()).ifPresent(arg_0 -> ((Qualitygates.ShowWsResponse.Condition.Builder)builder).setError(arg_0));
            return builder.build();
        };
    }

    private static void checkOneOfIdOrNamePresent(@Nullable Long qGateId, @Nullable String qGateName) {
        Preconditions.checkArgument((boolean)(qGateId == null ^ qGateName == null), (String)"Either '%s' or '%s' must be provided", (Object[])new Object[]{"id", "name"});
    }
}

