/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile;

import java.util.List;
import org.sonar.api.notifications.Notification;
import org.sonar.api.notifications.NotificationChannel;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.server.notification.NotificationDispatcher;
import org.sonar.server.notification.email.EmailNotificationChannel;

public class BuiltInQualityProfilesNotificationDispatcher
extends NotificationDispatcher {
    public static final String KEY = "BuiltInQP";
    private final EmailNotificationChannel emailNotificationChannel;
    private final DbClient dbClient;

    public BuiltInQualityProfilesNotificationDispatcher(EmailNotificationChannel emailNotificationChannel, DbClient dbClient) {
        super("built-in-quality-profiles");
        this.emailNotificationChannel = emailNotificationChannel;
        this.dbClient = dbClient;
    }

    public String getKey() {
        return KEY;
    }

    public void dispatch(Notification notification, NotificationDispatcher.Context context) {
        this.getRecipients().forEach(login -> context.addUser(login, (NotificationChannel)this.emailNotificationChannel));
    }

    private List<String> getRecipients() {
        try (DbSession session = this.dbClient.openSession(false);){
            List list = this.dbClient.authorizationDao().selectQualityProfileAdministratorLogins(session);
            return list;
        }
    }
}

