/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.rule.Severity;

@Immutable
public class RuleActivation {
    private final int ruleId;
    private final boolean reset;
    private final String severity;
    private final Map<String, String> parameters = new HashMap<String, String>();

    private RuleActivation(int ruleId, boolean reset, @Nullable String severity, @Nullable Map<String, String> parameters) {
        this.ruleId = ruleId;
        this.reset = reset;
        this.severity = severity;
        if (severity != null && !Severity.ALL.contains(severity)) {
            throw new IllegalArgumentException("Unknown severity: " + severity);
        }
        if (parameters != null) {
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                this.parameters.put(entry.getKey(), Strings.emptyToNull((String)entry.getValue()));
            }
        }
    }

    public static RuleActivation createReset(int ruleId) {
        return new RuleActivation(ruleId, true, null, null);
    }

    public static RuleActivation create(int ruleId, @Nullable String severity, @Nullable Map<String, String> parameters) {
        return new RuleActivation(ruleId, false, severity, parameters);
    }

    public static RuleActivation create(int ruleId) {
        return RuleActivation.create(ruleId, null, null);
    }

    @CheckForNull
    public String getSeverity() {
        return this.severity;
    }

    public int getRuleId() {
        return this.ruleId;
    }

    @CheckForNull
    public String getParameter(String key) {
        return this.parameters.get(key);
    }

    public boolean hasParameter(String key) {
        return this.parameters.containsKey(key);
    }

    public boolean isReset() {
        return this.reset;
    }
}

