/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.rule.ws;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.rule.Severity;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.ServerSide;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.rule.RuleDto;
import org.sonar.db.user.UserDto;
import org.sonar.server.organization.DefaultOrganization;
import org.sonar.server.organization.DefaultOrganizationProvider;
import org.sonar.server.qualityprofile.ActiveRuleInheritance;
import org.sonar.server.rule.index.RuleIndexDefinition;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;

@ServerSide
public class RuleWsSupport {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final DefaultOrganizationProvider defaultOrganizationProvider;

    public RuleWsSupport(DbClient dbClient, UserSession userSession, DefaultOrganizationProvider defaultOrganizationProvider) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.defaultOrganizationProvider = defaultOrganizationProvider;
    }

    public void checkQProfileAdminPermissionOnDefaultOrganization() {
        this.userSession.checkLoggedIn().checkPermission(OrganizationPermission.ADMINISTER_QUALITY_PROFILES, this.defaultOrganizationProvider.get().getUuid());
    }

    public OrganizationDto getOrganizationByKey(DbSession dbSession, @Nullable String organizationKey) {
        String organizationOrDefaultKey = Optional.ofNullable(organizationKey).orElseGet(() -> ((DefaultOrganization)this.defaultOrganizationProvider.get()).getKey());
        return (OrganizationDto)WsUtils.checkFoundWithOptional(this.dbClient.organizationDao().selectByKey(dbSession, organizationOrDefaultKey), "No organization with key '%s'", organizationOrDefaultKey);
    }

    Map<String, UserDto> getUsersByUuid(DbSession dbSession, List<RuleDto> rules) {
        Set userUuids = (Set)rules.stream().map(RuleDto::getNoteUserUuid).filter(Objects::nonNull).collect(MoreCollectors.toSet());
        return (Map)this.dbClient.userDao().selectByUuids(dbSession, (Collection)userUuids).stream().collect(MoreCollectors.uniqueIndex(UserDto::getUuid));
    }

    boolean areActiveRulesVisible(OrganizationDto organization) {
        if (!organization.getSubscription().equals((Object)OrganizationDto.Subscription.PAID)) {
            return true;
        }
        return this.userSession.hasMembership(organization);
    }

    public static void defineGenericRuleSearchParameters(WebService.NewAction action) {
        action.createParam("q").setMinimumLength(Integer.valueOf(2)).setDescription("UTF-8 search query").setExampleValue((Object)"xpath");
        action.createParam("rule_key").setDescription("Key of rule to search for").setExampleValue((Object)"squid:S001");
        action.createParam("repositories").setDescription("Comma-separated list of repositories").setExampleValue((Object)"checkstyle,findbugs");
        action.createParam("severities").setDescription("Comma-separated list of default severities. Not the same than severity of rules in Quality profiles.").setPossibleValues((Collection)Severity.ALL).setExampleValue((Object)"CRITICAL,BLOCKER");
        action.createParam("languages").setDescription("Comma-separated list of languages").setExampleValue((Object)"java,js");
        action.createParam("statuses").setDescription("Comma-separated list of status codes").setPossibleValues((Object[])RuleStatus.values()).setExampleValue((Object)RuleStatus.READY);
        action.createParam("available_since").setDescription("Filters rules added since date. Format is yyyy-MM-dd").setExampleValue((Object)"2014-06-22");
        action.createParam("tags").setDescription("Comma-separated list of tags. Returned rules match any of the tags (OR operator)").setExampleValue((Object)"security,java8");
        action.createParam("types").setSince("5.5").setDescription("Comma-separated list of types. Returned rules match any of the tags (OR operator)").setPossibleValues((Object[])RuleType.values()).setExampleValue((Object)RuleType.BUG);
        action.createParam("activation").setDescription("Filter rules that are activated or deactivated on the selected Quality profile. Ignored if the parameter 'qprofile' is not set.").setBooleanPossibleValues();
        action.createParam("qprofile").setDescription("Quality profile key to filter on. Used only if the parameter 'activation' is set.").setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy");
        action.createParam("compareToProfile").setDescription("Quality profile key to filter rules that are activated. Meant to compare easily to profile set in '%s'", new Object[]{"qprofile"}).setInternal(true).setSince("6.5").setExampleValue((Object)"AU-TpxcA-iU5OvuD2FLz");
        action.createParam("inheritance").setDescription("Comma-separated list of values of inheritance for a rule within a quality profile. Used only if the parameter 'activation' is set.").setPossibleValues((Object[])new String[]{ActiveRuleInheritance.NONE.name(), ActiveRuleInheritance.INHERITED.name(), ActiveRuleInheritance.OVERRIDES.name()}).setExampleValue((Object)(ActiveRuleInheritance.INHERITED.name() + "," + ActiveRuleInheritance.OVERRIDES.name()));
        action.createParam("active_severities").setDescription("Comma-separated list of activation severities, i.e the severity of rules in Quality profiles.").setPossibleValues((Collection)Severity.ALL).setExampleValue((Object)"CRITICAL,BLOCKER");
        action.createParam("is_template").setDescription("Filter template rules").setBooleanPossibleValues();
        action.createParam("template_key").setDescription("Key of the template rule to filter on. Used to search for the custom rules based on this template.").setExampleValue((Object)"java:S001");
        action.createParam("s").setDescription("Sort field").setPossibleValues((Collection)RuleIndexDefinition.SORT_FIELDS).setExampleValue(RuleIndexDefinition.SORT_FIELDS.iterator().next());
        action.createParam("asc").setDescription("Ascending sort").setBooleanPossibleValues().setDefaultValue((Object)true);
        action.createParam("organization").setDescription("Organization key").setRequired(false).setInternal(true).setExampleValue((Object)"my-org").setSince("6.4");
    }

    static void defineIsExternalParam(WebService.NewAction action) {
        action.createParam("include_external").setDescription("Include external engine rules in the results").setDefaultValue((Object)false).setBooleanPossibleValues().setSince("7.2");
    }
}

