/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.startup;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.sonar.api.Startable;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.core.platform.PluginInfo;
import org.sonar.core.util.UuidFactory;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.plugin.PluginDto;
import org.sonar.server.plugins.InstalledPlugin;
import org.sonar.server.plugins.PluginFileSystem;

@ServerSide
public class RegisterPlugins
implements Startable {
    private static final Logger LOG = Loggers.get(RegisterPlugins.class);
    private final PluginFileSystem pluginFileSystem;
    private final DbClient dbClient;
    private final UuidFactory uuidFactory;
    private final System2 system;

    public RegisterPlugins(PluginFileSystem pluginFileSystem, DbClient dbClient, UuidFactory uuidFactory, System2 system) {
        this.pluginFileSystem = pluginFileSystem;
        this.dbClient = dbClient;
        this.uuidFactory = uuidFactory;
        this.system = system;
    }

    public void start() {
        Profiler profiler = Profiler.create((Logger)LOG).startInfo("Register plugins");
        this.updateDB();
        profiler.stopDebug();
    }

    public void stop() {
    }

    private void updateDB() {
        long now = this.system.now();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Map allPreviousPluginsByKey = this.dbClient.pluginDao().selectAll(dbSession).stream().collect(Collectors.toMap(PluginDto::getKee, Function.identity()));
            for (InstalledPlugin installed : this.pluginFileSystem.getInstalledFiles()) {
                PluginInfo info = installed.getPluginInfo();
                PluginDto previousDto = (PluginDto)allPreviousPluginsByKey.get(info.getKey());
                if (previousDto == null) {
                    LOG.debug("Register new plugin {}", (Object)info.getKey());
                    PluginDto pluginDto = new PluginDto().setUuid(this.uuidFactory.create()).setKee(info.getKey()).setBasePluginKey(info.getBasePlugin()).setFileHash(installed.getLoadedJar().getMd5()).setCreatedAt(now).setUpdatedAt(now);
                    this.dbClient.pluginDao().insert(dbSession, pluginDto);
                    continue;
                }
                if (previousDto.getFileHash().equals(installed.getLoadedJar().getMd5())) continue;
                LOG.debug("Update plugin {}", (Object)info.getKey());
                previousDto.setBasePluginKey(info.getBasePlugin()).setFileHash(installed.getLoadedJar().getMd5()).setUpdatedAt(now);
                this.dbClient.pluginDao().update(dbSession, previousDto);
            }
            dbSession.commit();
        }
    }
}

