/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.user;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.user.UserDto;
import org.sonar.server.exceptions.ForbiddenException;
import org.sonar.server.exceptions.UnauthorizedException;
import org.sonar.server.user.UserSession;

public abstract class AbstractUserSession
implements UserSession {
    private static final Set<String> PUBLIC_PERMISSIONS = ImmutableSet.of((Object)"user", (Object)"codeviewer");
    private static final String INSUFFICIENT_PRIVILEGES_MESSAGE = "Insufficient privileges";
    private static final String AUTHENTICATION_IS_REQUIRED_MESSAGE = "Authentication is required";

    protected static Identity computeIdentity(UserDto userDto) {
        UserSession.IdentityProvider identityProvider = UserSession.IdentityProvider.getFromKey(userDto.getExternalIdentityProvider());
        UserSession.ExternalIdentity externalIdentity = identityProvider == UserSession.IdentityProvider.SONARQUBE ? null : AbstractUserSession.externalIdentityOf(userDto);
        return new Identity(identityProvider, externalIdentity);
    }

    private static UserSession.ExternalIdentity externalIdentityOf(UserDto userDto) {
        String externalId = userDto.getExternalId();
        String externalLogin = userDto.getExternalLogin();
        return new UserSession.ExternalIdentity(externalId, externalLogin);
    }

    @Override
    public final boolean hasPermission(OrganizationPermission permission, OrganizationDto organization) {
        return this.hasPermission(permission, organization.getUuid());
    }

    @Override
    public final boolean hasPermission(OrganizationPermission permission, String organizationUuid) {
        return this.isRoot() || this.hasPermissionImpl(permission, organizationUuid);
    }

    protected abstract boolean hasPermissionImpl(OrganizationPermission var1, String var2);

    @Override
    public final boolean hasComponentPermission(String permission, ComponentDto component) {
        if (this.isRoot()) {
            return true;
        }
        String projectUuid = StringUtils.defaultString((String)component.getMainBranchProjectUuid(), (String)component.projectUuid());
        return this.hasProjectUuidPermission(permission, projectUuid);
    }

    @Override
    public final boolean hasComponentUuidPermission(String permission, String componentUuid) {
        if (this.isRoot()) {
            return true;
        }
        Optional<String> projectUuid = this.componentUuidToProjectUuid(componentUuid);
        return projectUuid.map(s -> this.hasProjectUuidPermission(permission, (String)s)).orElse(false);
    }

    protected abstract Optional<String> componentUuidToProjectUuid(String var1);

    protected abstract boolean hasProjectUuidPermission(String var1, String var2);

    @Override
    public final boolean hasMembership(OrganizationDto organizationDto) {
        return this.isRoot() || this.hasMembershipImpl(organizationDto);
    }

    protected abstract boolean hasMembershipImpl(OrganizationDto var1);

    @Override
    public final List<ComponentDto> keepAuthorizedComponents(String permission, Collection<ComponentDto> components) {
        if (this.isRoot()) {
            return new ArrayList<ComponentDto>(components);
        }
        return this.doKeepAuthorizedComponents(permission, components);
    }

    protected List<ComponentDto> doKeepAuthorizedComponents(String permission, Collection<ComponentDto> components) {
        boolean allowPublicComponent = PUBLIC_PERMISSIONS.contains(permission);
        return (List)components.stream().filter(c -> allowPublicComponent && !c.isPrivate() || this.hasComponentPermission(permission, (ComponentDto)c)).collect(MoreCollectors.toList());
    }

    @Override
    public UserSession checkIsRoot() {
        if (!this.isRoot()) {
            throw new ForbiddenException(INSUFFICIENT_PRIVILEGES_MESSAGE);
        }
        return this;
    }

    @Override
    public final UserSession checkLoggedIn() {
        if (!this.isLoggedIn()) {
            throw new UnauthorizedException(AUTHENTICATION_IS_REQUIRED_MESSAGE);
        }
        return this;
    }

    @Override
    public final UserSession checkPermission(OrganizationPermission permission, OrganizationDto organization) {
        return this.checkPermission(permission, organization.getUuid());
    }

    @Override
    public final UserSession checkPermission(OrganizationPermission permission, String organizationUuid) {
        if (!this.hasPermission(permission, organizationUuid)) {
            throw new ForbiddenException(INSUFFICIENT_PRIVILEGES_MESSAGE);
        }
        return this;
    }

    @Override
    public final UserSession checkComponentPermission(String projectPermission, ComponentDto component) {
        if (!this.hasComponentPermission(projectPermission, component)) {
            throw new ForbiddenException(INSUFFICIENT_PRIVILEGES_MESSAGE);
        }
        return this;
    }

    @Override
    public final UserSession checkComponentUuidPermission(String permission, String componentUuid) {
        if (!this.hasComponentUuidPermission(permission, componentUuid)) {
            throw new ForbiddenException(INSUFFICIENT_PRIVILEGES_MESSAGE);
        }
        return this;
    }

    public static ForbiddenException insufficientPrivilegesException() {
        return new ForbiddenException(INSUFFICIENT_PRIVILEGES_MESSAGE);
    }

    @Override
    public final UserSession checkIsSystemAdministrator() {
        if (!this.isSystemAdministrator()) {
            throw AbstractUserSession.insufficientPrivilegesException();
        }
        return this;
    }

    @Override
    public UserSession checkMembership(OrganizationDto organization) {
        if (!this.hasMembership(organization)) {
            throw new ForbiddenException(String.format("You're not member of organization '%s'", organization.getKey()));
        }
        return this;
    }

    protected static final class Identity {
        private final UserSession.IdentityProvider identityProvider;
        private final UserSession.ExternalIdentity externalIdentity;

        private Identity(UserSession.IdentityProvider identityProvider, @Nullable UserSession.ExternalIdentity externalIdentity) {
            this.identityProvider = identityProvider;
            this.externalIdentity = externalIdentity;
        }

        public UserSession.IdentityProvider getIdentityProvider() {
            return this.identityProvider;
        }

        @CheckForNull
        public UserSession.ExternalIdentity getExternalIdentity() {
            return this.externalIdentity;
        }
    }
}

