/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.user.ws;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Multimap;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.DateUtils;
import org.sonar.api.utils.Paging;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.user.UserDto;
import org.sonar.server.es.SearchOptions;
import org.sonar.server.es.SearchResult;
import org.sonar.server.issue.ws.AvatarResolver;
import org.sonar.server.user.UserSession;
import org.sonar.server.user.index.UserDoc;
import org.sonar.server.user.index.UserIndex;
import org.sonar.server.user.index.UserQuery;
import org.sonar.server.user.ws.UserJsonWriter;
import org.sonar.server.user.ws.UsersWsAction;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Users;

public class SearchAction
implements UsersWsAction {
    private static final int MAX_PAGE_SIZE = 500;
    private final UserSession userSession;
    private final UserIndex userIndex;
    private final DbClient dbClient;
    private final AvatarResolver avatarResolver;

    public SearchAction(UserSession userSession, UserIndex userIndex, DbClient dbClient, AvatarResolver avatarResolver) {
        this.userSession = userSession;
        this.userIndex = userIndex;
        this.dbClient = dbClient;
        this.avatarResolver = avatarResolver;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("search").setDescription("Get a list of active users. <br/>The following fields are only returned when user has Administer System permission or for logged-in in user :<ul>   <li>'email'</li>   <li>'externalIdentity'</li>   <li>'externalProvider'</li>   <li>'groups'</li>   <li>'lastConnectionDate'</li>   <li>'tokensCount'</li></ul>Field 'lastConnectionDate' is only updated every hour, so it may not be accurate, for instance when a user authenticates many times in less than one hour.").setSince("3.6").setChangelog(new Change[]{new Change("7.7", "New field 'lastConnectionDate' is added to response"), new Change("7.4", "External identity is only returned to system administrators"), new Change("6.4", "Paging response fields moved to a Paging object"), new Change("6.4", "Avatar has been added to the response"), new Change("6.4", "Email is only returned when user has Administer System permission")}).setHandler((RequestHandler)this).setResponseExample(this.getClass().getResource("search-example.json"));
        action.createFieldsParam(UserJsonWriter.FIELDS).setDeprecatedSince("5.4");
        action.addPagingParams(50, 500);
        action.createParam("q").setMinimumLength(Integer.valueOf(2)).setDescription("Filter on login, name and email");
    }

    public void handle(Request request, Response response) throws Exception {
        Users.SearchWsResponse wsResponse = this.doHandle(SearchAction.toSearchRequest(request));
        WsUtils.writeProtobuf((Message)wsResponse, request, response);
    }

    private Users.SearchWsResponse doHandle(SearchRequest request) {
        SearchOptions options = new SearchOptions().setPage(request.getPage().intValue(), request.getPageSize().intValue());
        List<String> fields = request.getPossibleFields();
        SearchResult result = this.userIndex.search(UserQuery.builder().setTextQuery(request.getQuery()).build(), options);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            List logins = (List)result.getDocs().stream().map(UserDoc::login).collect(MoreCollectors.toList());
            Multimap groupsByLogin = this.dbClient.groupMembershipDao().selectGroupsByLogins(dbSession, (Collection)logins);
            List users = this.dbClient.userDao().selectByOrderedLogins(dbSession, (Collection)logins);
            Map tokenCountsByLogin = this.dbClient.userTokenDao().countTokensByUsers(dbSession, (Collection)users);
            Paging paging = Paging.forPageIndex((int)request.getPage()).withPageSize(request.getPageSize().intValue()).andTotal((int)result.getTotal());
            Users.SearchWsResponse searchWsResponse = this.buildResponse(users, (Multimap<String, String>)groupsByLogin, tokenCountsByLogin, fields, paging);
            return searchWsResponse;
        }
    }

    private Users.SearchWsResponse buildResponse(List<UserDto> users, Multimap<String, String> groupsByLogin, Map<String, Integer> tokenCountsByLogin, @Nullable List<String> fields, Paging paging) {
        Users.SearchWsResponse.Builder responseBuilder = Users.SearchWsResponse.newBuilder();
        users.forEach(user -> responseBuilder.addUsers(this.towsUser((UserDto)user, (Integer)MoreObjects.firstNonNull(tokenCountsByLogin.get(user.getUuid()), (Object)0), groupsByLogin.get((Object)user.getLogin()), (Collection<String>)fields)));
        responseBuilder.getPagingBuilder().setPageIndex(paging.pageIndex()).setPageSize(paging.pageSize()).setTotal(paging.total()).build();
        return responseBuilder.build();
    }

    private Users.SearchWsResponse.User towsUser(UserDto user, @Nullable Integer tokensCount, Collection<String> groups, @Nullable Collection<String> fields) {
        Users.SearchWsResponse.User.Builder userBuilder;
        block5: {
            block4: {
                userBuilder = Users.SearchWsResponse.User.newBuilder().setLogin(user.getLogin());
                SearchAction.setIfNeeded("name", fields, user.getName(), arg_0 -> ((Users.SearchWsResponse.User.Builder)userBuilder).setName(arg_0));
                if (this.userSession.isLoggedIn()) {
                    SearchAction.setIfNeeded("avatart", fields, Strings.emptyToNull((String)user.getEmail()), u -> userBuilder.setAvatar(this.avatarResolver.create(user)));
                    SearchAction.setIfNeeded("active", fields, user.isActive(), arg_0 -> ((Users.SearchWsResponse.User.Builder)userBuilder).setActive(arg_0));
                    SearchAction.setIfNeeded("local", fields, user.isLocal(), arg_0 -> ((Users.SearchWsResponse.User.Builder)userBuilder).setLocal(arg_0));
                    SearchAction.setIfNeeded("externalProvider", fields, user.getExternalIdentityProvider(), arg_0 -> ((Users.SearchWsResponse.User.Builder)userBuilder).setExternalProvider(arg_0));
                    SearchAction.setIfNeeded(SearchAction.isNeeded("scmAccounts", fields) && !user.getScmAccountsAsList().isEmpty(), user.getScmAccountsAsList(), scm -> userBuilder.setScmAccounts(Users.SearchWsResponse.ScmAccounts.newBuilder().addAllScmAccounts((Iterable)scm)));
                }
                if (this.userSession.isSystemAdministrator()) break block4;
                if (!Objects.equals(this.userSession.getUuid(), user.getUuid())) break block5;
            }
            SearchAction.setIfNeeded("email", fields, user.getEmail(), arg_0 -> ((Users.SearchWsResponse.User.Builder)userBuilder).setEmail(arg_0));
            SearchAction.setIfNeeded(SearchAction.isNeeded("groups", fields) && !groups.isEmpty(), groups, g -> userBuilder.setGroups(Users.SearchWsResponse.Groups.newBuilder().addAllGroups((Iterable)g)));
            SearchAction.setIfNeeded("externalIdentity", fields, user.getExternalLogin(), arg_0 -> ((Users.SearchWsResponse.User.Builder)userBuilder).setExternalIdentity(arg_0));
            SearchAction.setIfNeeded("tokensCount", fields, tokensCount, arg_0 -> ((Users.SearchWsResponse.User.Builder)userBuilder).setTokensCount(arg_0));
            Optional.ofNullable(user.getLastConnectionDate()).ifPresent(date -> userBuilder.setLastConnectionDate(DateUtils.formatDateTime((long)date)));
        }
        return userBuilder.build();
    }

    private static <PARAM> void setIfNeeded(String field, @Nullable Collection<String> fields, @Nullable PARAM parameter, Function<PARAM, ?> setter) {
        SearchAction.setIfNeeded(SearchAction.isNeeded(field, fields), parameter, setter);
    }

    private static <PARAM> void setIfNeeded(boolean condition, @Nullable PARAM parameter, Function<PARAM, ?> setter) {
        if (parameter != null && condition) {
            setter.apply(parameter);
        }
    }

    private static boolean isNeeded(String field, @Nullable Collection<String> fields) {
        return fields == null || fields.isEmpty() || fields.contains(field);
    }

    private static SearchRequest toSearchRequest(Request request) {
        int pageSize = request.mandatoryParamAsInt("ps");
        Preconditions.checkArgument((pageSize <= 500 ? 1 : 0) != 0, (String)"The '%s' parameter must be less than %s", (Object[])new Object[]{"ps", 500});
        return SearchRequest.builder().setQuery(request.param("q")).setPage(request.mandatoryParamAsInt("p")).setPageSize(pageSize).setPossibleFields(request.paramAsStrings("f")).build();
    }

    private static class Builder {
        private Integer page;
        private Integer pageSize;
        private String query;
        private List<String> additionalFields = new ArrayList<String>();

        private Builder() {
        }

        public Builder setPage(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public Builder setPageSize(@Nullable Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder setQuery(@Nullable String query) {
            this.query = query;
            return this;
        }

        public Builder setPossibleFields(List<String> possibleFields) {
            this.additionalFields = possibleFields;
            return this;
        }

        public SearchRequest build() {
            return new SearchRequest(this);
        }
    }

    private static class SearchRequest {
        private final Integer page;
        private final Integer pageSize;
        private final String query;
        private final List<String> possibleFields;

        private SearchRequest(Builder builder) {
            this.page = builder.page;
            this.pageSize = builder.pageSize;
            this.query = builder.query;
            this.possibleFields = builder.additionalFields;
        }

        @CheckForNull
        public Integer getPage() {
            return this.page;
        }

        @CheckForNull
        public Integer getPageSize() {
            return this.pageSize;
        }

        @CheckForNull
        public String getQuery() {
            return this.query;
        }

        public List<String> getPossibleFields() {
            return this.possibleFields;
        }

        public static Builder builder() {
            return new Builder();
        }
    }
}

