/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.user.ws;

import com.google.common.base.Preconditions;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.user.UserDto;
import org.sonar.server.user.UserSession;
import org.sonar.server.user.ws.UsersWsAction;

public class SkipOnboardingTutorialAction
implements UsersWsAction {
    private final UserSession userSession;
    private final DbClient dbClient;

    public SkipOnboardingTutorialAction(UserSession userSession, DbClient dbClient) {
        this.userSession = userSession;
        this.dbClient = dbClient;
    }

    public void define(WebService.NewController context) {
        context.createAction("skip_onboarding_tutorial").setPost(true).setInternal(true).setDescription("Stores that the user has skipped the onboarding tutorial and does not want to see it after future logins.<br/>Requires authentication.").setSince("6.5").setHandler((RequestHandler)this);
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn();
        try (DbSession dbSession = this.dbClient.openSession(false);){
            String userLogin = this.userSession.getLogin();
            UserDto userDto = this.dbClient.userDao().selectActiveUserByLogin(dbSession, userLogin);
            Preconditions.checkState((userDto != null ? 1 : 0) != 0, (String)"User login '%s' cannot be found", (Object[])new Object[]{userLogin});
            if (!userDto.isOnboarded()) {
                userDto.setOnboarded(true);
                this.dbClient.userDao().update(dbSession, userDto);
                dbSession.commit();
            }
        }
        response.noContent();
    }
}

