/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.user.ws;

import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.user.UserDto;
import org.sonar.server.exceptions.NotFoundException;
import org.sonar.server.organization.OrganizationUpdater;
import org.sonar.server.user.UpdateUser;
import org.sonar.server.user.UserSession;
import org.sonar.server.user.UserUpdater;
import org.sonar.server.user.ws.UsersWsAction;

public class UpdateLoginAction
implements UsersWsAction {
    public static final String PARAM_LOGIN = "login";
    public static final String PARAM_NEW_LOGIN = "newLogin";
    private final DbClient dbClient;
    private final UserSession userSession;
    private final UserUpdater userUpdater;
    private final OrganizationUpdater organizationUpdater;

    public UpdateLoginAction(DbClient dbClient, UserSession userSession, UserUpdater userUpdater, OrganizationUpdater organizationUpdater) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.userUpdater = userUpdater;
        this.organizationUpdater = organizationUpdater;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("update_login").setDescription("Update a user login. A login can be updated many times.<br/>Requires Administer System permission").setSince("7.6").setPost(true).setHandler((RequestHandler)this);
        action.createParam(PARAM_LOGIN).setRequired(true).setDescription("The current login (case-sensitive)").setExampleValue((Object)"mylogin");
        action.createParam(PARAM_NEW_LOGIN).setRequired(true).setMaximumLength(Integer.valueOf(255)).setMinimumLength(Integer.valueOf(2)).setDescription("The new login. It must not already exist.").setExampleValue((Object)"mynewlogin");
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn().checkIsSystemAdministrator();
        String login = request.mandatoryParam(PARAM_LOGIN);
        String newLogin = request.mandatoryParam(PARAM_NEW_LOGIN);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            UserDto user = this.getUser(dbSession, login);
            this.userUpdater.updateAndCommit(dbSession, user, new UpdateUser().setLogin(newLogin), u -> this.updatePersonalOrganization(dbSession, (UserDto)u), new UserDto[0]);
            response.noContent();
        }
    }

    private UserDto getUser(DbSession dbSession, String login) {
        UserDto user = this.dbClient.userDao().selectByLogin(dbSession, login);
        if (user == null || !user.isActive()) {
            throw new NotFoundException(String.format("User '%s' doesn't exist", login));
        }
        return user;
    }

    private void updatePersonalOrganization(DbSession dbSession, UserDto user) {
        String personalOrganizationUuid = user.getOrganizationUuid();
        if (personalOrganizationUuid == null) {
            return;
        }
        this.dbClient.organizationDao().selectByUuid(dbSession, personalOrganizationUuid).ifPresent(organization -> this.organizationUpdater.updateOrganizationKey(dbSession, (OrganizationDto)organization, user.getLogin()));
    }
}

