/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.webhook.ws;

import java.util.Optional;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.webhook.WebhookDto;
import org.sonar.server.user.UserSession;
import org.sonar.server.webhook.ws.WebhookSupport;
import org.sonar.server.webhook.ws.WebhooksWsAction;
import org.sonar.server.ws.WsUtils;

public class DeleteAction
implements WebhooksWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final WebhookSupport webhookSupport;

    public DeleteAction(DbClient dbClient, UserSession userSession, WebhookSupport webhookSupport) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.webhookSupport = webhookSupport;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("delete").setPost(true).setDescription("Delete a Webhook.<br>Requires 'Administer' permission on the specified project, or global 'Administer' permission.").setSince("7.1").setHandler((RequestHandler)this);
        action.createParam("webhook").setRequired(true).setMaximumLength(Integer.valueOf(40)).setDescription("The key of the webhook to be deleted, auto-generated value can be obtained through api/webhooks/create or api/webhooks/list").setExampleValue((Object)"my_project");
    }

    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn();
        String webhookKey = request.param("webhook");
        try (DbSession dbSession = this.dbClient.openSession(false);){
            String projectUuid;
            Optional dtoOptional = this.dbClient.webhookDao().selectByUuid(dbSession, webhookKey);
            WebhookDto webhookDto = (WebhookDto)WsUtils.checkFoundWithOptional(dtoOptional, "No webhook with key '%s'", webhookKey);
            String organizationUuid = webhookDto.getOrganizationUuid();
            if (organizationUuid != null) {
                Optional optionalDto = this.dbClient.organizationDao().selectByUuid(dbSession, organizationUuid);
                OrganizationDto organizationDto = (OrganizationDto)WsUtils.checkStateWithOptional(optionalDto, "the requested organization '%s' was not found", organizationUuid);
                this.webhookSupport.checkPermission(organizationDto);
                this.deleteWebhook(dbSession, webhookDto);
            }
            if ((projectUuid = webhookDto.getProjectUuid()) != null) {
                Optional<Object> optionalDto = Optional.ofNullable(this.dbClient.componentDao().selectByUuid(dbSession, projectUuid).orElse(null));
                ComponentDto componentDto = WsUtils.checkStateWithOptional(optionalDto, "the requested project '%s' was not found", projectUuid);
                this.webhookSupport.checkPermission(componentDto);
                this.deleteWebhook(dbSession, webhookDto);
            }
            dbSession.commit();
        }
        response.noContent();
    }

    private void deleteWebhook(DbSession dbSession, WebhookDto webhookDto) {
        this.dbClient.webhookDeliveryDao().deleteByWebhook(dbSession, webhookDto);
        this.dbClient.webhookDao().delete(dbSession, webhookDto.getUuid());
    }
}

