/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.webhook.ws;

import com.google.common.io.Resources;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.DateUtils;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.webhook.WebhookDeliveryLiteDto;
import org.sonar.db.webhook.WebhookDto;
import org.sonar.server.organization.DefaultOrganizationProvider;
import org.sonar.server.user.UserSession;
import org.sonar.server.webhook.HttpUrlHelper;
import org.sonar.server.webhook.ws.WebhookSupport;
import org.sonar.server.webhook.ws.WebhooksWsAction;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Webhooks;

public class ListAction
implements WebhooksWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final DefaultOrganizationProvider defaultOrganizationProvider;
    private final WebhookSupport webhookSupport;

    public ListAction(DbClient dbClient, UserSession userSession, DefaultOrganizationProvider defaultOrganizationProvider, WebhookSupport webhookSupport) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.defaultOrganizationProvider = defaultOrganizationProvider;
        this.webhookSupport = webhookSupport;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("list").setDescription("Search for global webhooks or project webhooks. Webhooks are ordered by name.<br>Requires 'Administer' permission on the specified project, or global 'Administer' permission.").setSince("7.1").setResponseExample(Resources.getResource(this.getClass(), (String)"example-webhooks-search.json")).setHandler((RequestHandler)this);
        action.createParam("organization").setDescription("Organization key. If no organization is provided, the default organization is used.").setInternal(true).setRequired(false).setExampleValue((Object)"my-org");
        action.createParam("project").setDescription("Project key").setRequired(false).setExampleValue((Object)"my_project");
    }

    public void handle(Request request, Response response) throws Exception {
        String projectKey = request.param("project");
        String organizationKey = request.param("organization");
        this.userSession.checkLoggedIn();
        try (DbSession dbSession = this.dbClient.openSession(true);){
            List<WebhookDto> webhookDtos = this.doHandle(dbSession, organizationKey, projectKey);
            Map<String, WebhookDeliveryLiteDto> lastDeliveries = this.loadLastDeliveriesOf(dbSession, webhookDtos);
            ListAction.writeResponse(request, response, webhookDtos, lastDeliveries);
        }
    }

    private Map<String, WebhookDeliveryLiteDto> loadLastDeliveriesOf(DbSession dbSession, List<WebhookDto> webhookDtos) {
        return this.dbClient.webhookDeliveryDao().selectLatestDeliveries(dbSession, webhookDtos);
    }

    private List<WebhookDto> doHandle(DbSession dbSession, @Nullable String organizationKey, @Nullable String projectKey) {
        OrganizationDto organizationDto;
        if (StringUtils.isNotBlank((String)organizationKey)) {
            Optional dtoOptional = this.dbClient.organizationDao().selectByKey(dbSession, organizationKey);
            organizationDto = (OrganizationDto)WsUtils.checkFoundWithOptional(dtoOptional, "No organization with key '%s'", organizationKey);
        } else {
            organizationDto = this.defaultOrganizationDto(dbSession);
        }
        if (StringUtils.isNotBlank((String)projectKey)) {
            Optional<Object> optional = Optional.ofNullable(this.dbClient.componentDao().selectByKey(dbSession, projectKey).orElse(null));
            ComponentDto componentDto = WsUtils.checkFoundWithOptional(optional, "project %s does not exist", projectKey);
            this.webhookSupport.checkPermission(componentDto);
            this.webhookSupport.checkThatProjectBelongsToOrganization(componentDto, organizationDto, "Project '%s' does not belong to organisation '%s'", projectKey, organizationKey);
            this.webhookSupport.checkPermission(componentDto);
            return this.dbClient.webhookDao().selectByProject(dbSession, componentDto);
        }
        this.webhookSupport.checkPermission(organizationDto);
        return this.dbClient.webhookDao().selectByOrganization(dbSession, organizationDto);
    }

    private static void writeResponse(Request request, Response response, List<WebhookDto> webhookDtos, Map<String, WebhookDeliveryLiteDto> lastDeliveries) {
        Webhooks.ListResponse.Builder responseBuilder = Webhooks.ListResponse.newBuilder();
        webhookDtos.forEach(webhook -> {
            Webhooks.ListResponseElement.Builder responseElementBuilder = responseBuilder.addWebhooksBuilder();
            responseElementBuilder.setKey(webhook.getUuid()).setName(webhook.getName()).setUrl(HttpUrlHelper.obfuscateCredentials((String)webhook.getUrl()));
            ListAction.addLastDelivery(responseElementBuilder, webhook, lastDeliveries);
        });
        WsUtils.writeProtobuf((Message)responseBuilder.build(), request, response);
    }

    private static void addLastDelivery(Webhooks.ListResponseElement.Builder responseElementBuilder, WebhookDto webhook, Map<String, WebhookDeliveryLiteDto> lastDeliveries) {
        if (lastDeliveries.containsKey(webhook.getUuid())) {
            WebhookDeliveryLiteDto delivery = lastDeliveries.get(webhook.getUuid());
            Webhooks.LatestDelivery.Builder builder = responseElementBuilder.getLatestDeliveryBuilder().setId(delivery.getUuid()).setAt(DateUtils.formatDateTime((long)delivery.getCreatedAt())).setSuccess(delivery.isSuccess());
            if (delivery.getHttpStatus() != null) {
                builder.setHttpStatus(delivery.getHttpStatus().intValue());
            }
            if (delivery.getDurationMs() != null) {
                builder.setDurationMs(delivery.getDurationMs().intValue());
            }
            builder.build();
        }
    }

    private OrganizationDto defaultOrganizationDto(DbSession dbSession) {
        String uuid = this.defaultOrganizationProvider.get().getUuid();
        Optional organizationDto = this.dbClient.organizationDao().selectByUuid(dbSession, uuid);
        return (OrganizationDto)WsUtils.checkStateWithOptional(organizationDto, "the default organization '%s' was not found", uuid);
    }
}

