/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonruleengine;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.commonruleengine.Issue;
import org.sonar.uast.UastNode;
import org.sonar.uast.helpers.BinaryExpressionLike;
import org.sonar.uast.helpers.BranchLike;
import org.sonar.uast.helpers.IfLike;
import org.sonar.uast.helpers.ParenthesizedLike;

public class CognitiveComplexity {
    private boolean inAFunction = false;
    private int complexity = 0;
    private int nesting = 1;
    @Nullable
    private final List<Issue.Message> secondaryLocations;
    private final Set<UastNode> ignoredNode = new HashSet<UastNode>();

    private CognitiveComplexity(@Nullable List<Issue.Message> secondaryLocations) {
        this.secondaryLocations = secondaryLocations;
    }

    public static CognitiveComplexity calculateFunctionComplexity(UastNode function) {
        CognitiveComplexity complexityVisitor = new CognitiveComplexity(new ArrayList<Issue.Message>());
        complexityVisitor.visit(null, function);
        return complexityVisitor;
    }

    public static CognitiveComplexity calculateFileComplexity(UastNode compilationUnit) {
        CognitiveComplexity complexityVisitor = new CognitiveComplexity(null);
        complexityVisitor.visit(null, compilationUnit);
        return complexityVisitor;
    }

    private void visit(@Nullable UastNode parent, UastNode node) {
        BranchLike branchStatement = BranchLike.from(node);
        if (node.is(UastNode.Kind.FUNCTION)) {
            this.visitFunction(node);
        } else if (parent == null || !this.inAFunction || this.ignoredNode.contains(node)) {
            this.visitChildren(node);
        } else if (node.is(UastNode.Kind.ELSE)) {
            this.increaseComplexityByOne(CognitiveComplexity.keyword(parent, node));
            this.visitChildren(node);
        } else if (node.is(UastNode.Kind.IF, UastNode.Kind.SWITCH, UastNode.Kind.LOOP)) {
            this.increaseComplexityByNesting(CognitiveComplexity.keyword(parent, node));
            this.visitNestedChildren(node);
        } else if (branchStatement != null && branchStatement.label() != null) {
            this.increaseComplexityByOne(CognitiveComplexity.keyword(parent, node));
        } else if (node.is(UastNode.Kind.BINARY_EXPRESSION)) {
            this.visitBinaryExpression(node);
        } else if (node.is(UastNode.Kind.FUNCTION_LITERAL)) {
            this.visitNestedChildren(node);
        } else {
            this.visitChildren(node);
        }
    }

    private void visitFunction(UastNode node) {
        if (this.inAFunction) {
            this.visitNestedChildren(node);
        } else {
            this.inAFunction = true;
            this.visitChildren(node);
            this.inAFunction = false;
        }
    }

    private void visitBinaryExpression(UastNode node) {
        ArrayList<BinaryExpressionLike> expressionAsList = new ArrayList<BinaryExpressionLike>();
        CognitiveComplexity.flattenBinaryExpressions(node, expressionAsList);
        UastNode.Kind lastLogicalOperatorKind = null;
        for (BinaryExpressionLike binaryExpression : expressionAsList) {
            UastNode.Kind kind = CognitiveComplexity.logicalBinaryExpressionKind(binaryExpression);
            if (kind != null) {
                if (binaryExpression.node() != node) {
                    this.ignoredNode.add(binaryExpression.node());
                }
                if (kind != lastLogicalOperatorKind) {
                    this.increaseComplexityByOne(binaryExpression.operator());
                }
            }
            lastLogicalOperatorKind = kind;
        }
        this.visitChildren(node);
    }

    private static void flattenBinaryExpressions(UastNode node, List<BinaryExpressionLike> expressionAsList) {
        ParenthesizedLike parenthesizedNode = ParenthesizedLike.from(node);
        if (parenthesizedNode != null) {
            CognitiveComplexity.flattenBinaryExpressions(parenthesizedNode.expression(), expressionAsList);
            return;
        }
        BinaryExpressionLike binaryExpression = BinaryExpressionLike.from(node);
        if (binaryExpression != null && CognitiveComplexity.logicalBinaryExpressionKind(binaryExpression) != null) {
            CognitiveComplexity.flattenBinaryExpressions(binaryExpression.leftOperand(), expressionAsList);
            expressionAsList.add(binaryExpression);
            CognitiveComplexity.flattenBinaryExpressions(binaryExpression.rightOperand(), expressionAsList);
        }
    }

    @Nullable
    private static UastNode.Kind logicalBinaryExpressionKind(BinaryExpressionLike binaryExpression) {
        if (binaryExpression.node().is(UastNode.Kind.LOGICAL_AND)) {
            return UastNode.Kind.LOGICAL_AND;
        }
        if (binaryExpression.node().is(UastNode.Kind.LOGICAL_OR)) {
            return UastNode.Kind.LOGICAL_OR;
        }
        return null;
    }

    private void visitNestedChildren(UastNode node) {
        this.incrementNesting();
        this.visitChildren(node);
        this.decrementNesting();
    }

    private void visitChildren(UastNode node) {
        for (UastNode child : node.children) {
            this.visit(node, child);
        }
    }

    private static UastNode keyword(UastNode parent, UastNode node) {
        IfLike.ElseLike elseLike;
        IfLike ifNode;
        if (node.is(UastNode.Kind.ELSE) && (ifNode = IfLike.from(parent)) != null && (elseLike = ifNode.elseLike()) != null) {
            return elseLike.elseKeyword();
        }
        return node.getChild(UastNode.Kind.KEYWORD).orElse(node);
    }

    public int value() {
        return this.complexity;
    }

    public Issue.Message[] secondaryLocations() {
        if (this.secondaryLocations != null) {
            return this.secondaryLocations.toArray(new Issue.Message[this.secondaryLocations.size()]);
        }
        return new Issue.Message[0];
    }

    private void incrementNesting() {
        ++this.nesting;
    }

    private void decrementNesting() {
        --this.nesting;
    }

    private void increaseComplexityByNesting(UastNode node) {
        this.increaseComplexity(node, this.nesting);
    }

    private void increaseComplexityByOne(UastNode node) {
        this.increaseComplexity(node, 1);
    }

    private void increaseComplexity(UastNode node, int increase) {
        this.complexity += increase;
        this.addSecondaryLocation(node, increase);
    }

    private void addSecondaryLocation(UastNode node, int increase) {
        if (this.secondaryLocations != null) {
            String message = increase == 1 ? "+1" : "+" + increase + " (incl " + (increase - 1) + " for nesting)";
            this.secondaryLocations.add(new Issue.Message(node, message));
        }
    }
}

