/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonruleengine.checks;

import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.commonruleengine.checks.Check;
import org.sonar.uast.UastNode;

@Rule(key="S1186")
public class EmptyFunctionCheck
extends Check {
    public EmptyFunctionCheck() {
        super(UastNode.Kind.FUNCTION, UastNode.Kind.FUNCTION_LITERAL);
    }

    @Override
    public void visitNode(UastNode node) {
        Optional<UastNode> block = node.getChild(UastNode.Kind.BLOCK);
        block.ifPresent(blck -> {
            if (blck.children.stream().allMatch(child -> EmptyFunctionCheck.isBraceBracket(child.token))) {
                this.reportIssue(node, "Add a nested comment explaining why this function is empty or complete the implementation.");
            }
        });
    }

    private static boolean isBraceBracket(@Nullable UastNode.Token token) {
        return token != null && ("{".equals(token.value) || "}".equals(token.value));
    }
}

