/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonruleengine.checks;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.commonruleengine.checks.Check;
import org.sonar.uast.UastNode;

@Rule(key="S1134")
public class FixMeTagPresenceCheck
extends Check {
    private static final Pattern FIXME_PATTERN = Pattern.compile("\\WFIXME(\\W|$)");

    public FixMeTagPresenceCheck() {
        super(UastNode.Kind.COMMENT, UastNode.Kind.STRUCTURED_COMMENT);
    }

    @Override
    public void visitNode(UastNode node) {
        String comment;
        Matcher matcher;
        if (node.token != null && (matcher = FIXME_PATTERN.matcher(comment = node.token.value.toUpperCase(Locale.ENGLISH))).find()) {
            this.reportIssue(node, "Take the required action to fix the issue indicated by this \"FIXME\" comment.");
        }
    }
}

