/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonruleengine.checks;

import java.util.ArrayList;
import java.util.List;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.check.Rule;
import org.sonar.commonruleengine.Issue;
import org.sonar.commonruleengine.checks.Check;
import org.sonar.uast.SyntacticEquivalence;
import org.sonar.uast.UastNode;
import org.sonar.uast.helpers.FunctionLike;

@Rule(key="S4144")
public class NoIdenticalFunctionsCheck
extends Check {
    private List<FunctionLike> functions = new ArrayList<FunctionLike>();

    public NoIdenticalFunctionsCheck() {
        super(UastNode.Kind.FUNCTION, UastNode.Kind.CLASS);
    }

    @Override
    public void enterFile(InputFile inputFile) {
        this.functions.clear();
    }

    @Override
    public void visitNode(UastNode node) {
        if (node.is(UastNode.Kind.CLASS)) {
            this.functions.clear();
        }
        if (node.is(FunctionLike.KIND)) {
            FunctionLike thisFunction = FunctionLike.from(node);
            if (thisFunction == null) {
                return;
            }
            if (thisFunction.body().getChildren(UastNode.Kind.STATEMENT).size() < 2) {
                return;
            }
            for (FunctionLike function : this.functions) {
                if (!SyntacticEquivalence.areEquivalent(thisFunction.body(), function.body()) || !SyntacticEquivalence.areEquivalent(thisFunction.parameters(), function.parameters()) || !SyntacticEquivalence.areEquivalent(thisFunction.resultList(), function.resultList())) continue;
                this.reportIssue(thisFunction.name(), "Function is identical with function on line " + function.node().firstToken().line + ".", new Issue.Message(function.name(), "Original implementation"));
                break;
            }
            this.functions.add(thisFunction);
        }
    }
}

