/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonruleengine.checks;

import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.commonruleengine.Issue;
import org.sonar.commonruleengine.checks.Check;
import org.sonar.uast.UastNode;
import org.sonar.uast.helpers.SwitchLike;

@Rule(key="S1479")
public class SwitchWithTooManyCaseCheck
extends Check {
    private static final int DEFAULT_MAXIMUM_CASES = 30;
    @RuleProperty(key="maximum", description="Maximum number of case", defaultValue="30")
    public int maximumCases = 30;

    public SwitchWithTooManyCaseCheck() {
        super(UastNode.Kind.SWITCH);
    }

    @Override
    public void visitNode(UastNode node) {
        SwitchLike switchLike = SwitchLike.from(node);
        int casesNb = switchLike.caseNodes().size();
        if (casesNb > this.maximumCases) {
            Issue.Message[] secondaries = (Issue.Message[])switchLike.caseNodes().stream().map(cn -> new Issue.Message(cn.getChild(UastNode.Kind.KEYWORD).orElse((UastNode)cn), "+1")).toArray(Issue.Message[]::new);
            this.reportIssue(switchLike.switchKeyword(), String.format("Reduce the number of switch cases from %d to at most %d.", casesNb, this.maximumCases), secondaries);
        }
    }
}

