/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.commonruleengine.checks;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.commonruleengine.Issue;
import org.sonar.commonruleengine.checks.Check;
import org.sonar.uast.UastNode;

@Rule(key="S1172")
public class UnusedParameterCheck
extends Check {
    private static final String MESSAGE = "Remove the unused function parameter(s) \"%s\".";

    public UnusedParameterCheck() {
        super(UastNode.Kind.FUNCTION, UastNode.Kind.FUNCTION_LITERAL);
    }

    @Override
    public void visitNode(UastNode node) {
        Optional<UastNode> functionBody = node.getChild(UastNode.Kind.BLOCK);
        if (UnusedParameterCheck.isMethod(node) || !functionBody.isPresent()) {
            return;
        }
        List<UastNode> parameterNames = UnusedParameterCheck.getParameterNameNodes(node);
        Set<String> identifiersInBody = UnusedParameterCheck.getIdentifierNames(functionBody.get());
        List<UastNode> unusedParameters = parameterNames.stream().filter(parameterName -> !UnusedParameterCheck.isParameterUsed(parameterName, identifiersInBody)).collect(Collectors.toList());
        if (!unusedParameters.isEmpty()) {
            String parametersJoined = unusedParameters.stream().map(parameter -> parameter.token.value).collect(Collectors.joining("\", \""));
            String message = String.format(MESSAGE, parametersJoined);
            this.reportIssue((UastNode)unusedParameters.get(0), message, UnusedParameterCheck.secondaryMessages(unusedParameters));
        }
    }

    private static Set<String> getIdentifierNames(UastNode functionBody) {
        HashSet<String> identifiersInBody = new HashSet<String>();
        functionBody.getDescendants(UastNode.Kind.IDENTIFIER, identifier -> {
            if (identifier.token != null) {
                identifiersInBody.add(identifier.token.value);
            }
        });
        return identifiersInBody;
    }

    private static List<UastNode> getParameterNameNodes(UastNode functionNode) {
        ArrayList<UastNode> parameterNames = new ArrayList<UastNode>();
        functionNode.getDescendants(UastNode.Kind.PARAMETER_LIST, parameterDeclaration -> parameterDeclaration.getDescendants(UastNode.Kind.VARIABLE_NAME, parameterName -> {
            if (parameterName.is(UastNode.Kind.IDENTIFIER) && parameterName.token != null) {
                parameterNames.add((UastNode)parameterName);
            }
        }));
        return parameterNames;
    }

    private static boolean isParameterUsed(UastNode parameterName, Set<String> identifiersInBody) {
        String name = parameterName.token.value;
        return name.equals("_") || identifiersInBody.contains(name);
    }

    private static boolean isMethod(UastNode functionNode) {
        ArrayList parameterDeclarations = new ArrayList();
        functionNode.getDescendants(UastNode.Kind.PARAMETER_LIST, parameterDeclarations::add);
        for (UastNode parameterDeclaration : parameterDeclarations) {
            if (!parameterDeclaration.nativeNode.contains("Recv")) continue;
            return true;
        }
        return false;
    }

    private static Issue.Message[] secondaryMessages(List<UastNode> nodes) {
        return (Issue.Message[])nodes.stream().skip(1L).map(Issue.Message::new).toArray(Issue.Message[]::new);
    }
}

