/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.plugin;

import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonar.go.plugin.utils.PluginApiUtils;
import org.sonar.uast.UastNode;

public class HighlightingVisitor {
    private final InputFile inputFile;
    private final NewHighlighting newHighlighting;

    public HighlightingVisitor(SensorContext sensorContext, InputFile inputFile) {
        this.inputFile = inputFile;
        this.newHighlighting = sensorContext.newHighlighting().onFile(inputFile);
    }

    public void scan(UastNode node) {
        this.scanRecursively(node, false);
    }

    public void scanRecursively(UastNode node, boolean parentIsATypeDefinition) {
        boolean isATypeDefinition;
        UastNode.Token token = node.token;
        boolean bl = isATypeDefinition = parentIsATypeDefinition || node.is(UastNode.Kind.TYPE);
        if (token != null) {
            if (node.is(UastNode.Kind.COMMENT)) {
                this.highlight(token, node.is(UastNode.Kind.STRUCTURED_COMMENT) ? TypeOfText.STRUCTURED_COMMENT : TypeOfText.COMMENT);
            } else if (node.is(UastNode.Kind.KEYWORD)) {
                this.highlight(token, TypeOfText.KEYWORD);
            } else if (node.is(UastNode.Kind.LITERAL)) {
                this.highlight(token, node.is(UastNode.Kind.STRING_LITERAL) ? TypeOfText.STRING : TypeOfText.CONSTANT);
            } else if (isATypeDefinition) {
                this.highlight(token, TypeOfText.KEYWORD_LIGHT);
            }
        }
        for (UastNode child : node.children) {
            this.scanRecursively(child, isATypeDefinition);
        }
    }

    private NewHighlighting highlight(UastNode.Token token, TypeOfText typeOfText) {
        return this.newHighlighting.highlight(PluginApiUtils.newRange(this.inputFile, token), typeOfText);
    }

    public void save() {
        this.newHighlighting.save();
    }
}

