/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.uast;

import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.uast.UastNode;

class Unmarshaller {
    private static final Map<String, UastNode.Kind> KIND_MAP = Arrays.stream(UastNode.Kind.values()).collect(Collectors.toMap(Enum::name, Function.identity()));
    private final JsonReader reader;

    private Unmarshaller(Reader reader) {
        this.reader = new JsonReader(reader);
        this.reader.setLenient(true);
    }

    static UastNode unmarshal(Reader reader) throws IOException {
        Unmarshaller unmarshaller = new Unmarshaller(reader);
        return unmarshaller.readNode();
    }

    private UastNode readNode() throws IOException {
        Set<UastNode.Kind> kinds = Collections.emptySet();
        String nativeNode = "";
        UastNode.Token token = null;
        List<UastNode> children = Collections.emptyList();
        this.reader.beginObject();
        block12: while (this.reader.hasNext()) {
            String name;
            switch (name = this.reader.nextName()) {
                case "kinds": {
                    kinds = this.readKinds();
                    continue block12;
                }
                case "nativeNode": {
                    nativeNode = this.readNullable(this.reader::nextString, "");
                    continue block12;
                }
                case "token": {
                    token = this.readNullable(this::readToken, null);
                    continue block12;
                }
                case "children": {
                    children = this.readNullable(this::readChildren, Collections.emptyList());
                    continue block12;
                }
            }
            this.reader.skipValue();
        }
        this.reader.endObject();
        return new UastNode(kinds, nativeNode, token, children);
    }

    private List<UastNode> readChildren() throws IOException {
        ArrayList<UastNode> children = new ArrayList<UastNode>();
        this.reader.beginArray();
        while (this.reader.hasNext()) {
            UastNode uastNode = this.readNode();
            children.add(uastNode);
        }
        this.reader.endArray();
        return children;
    }

    private UastNode.Token readToken() throws IOException {
        int line = -1;
        int column = -1;
        String value = "";
        this.reader.beginObject();
        block10: while (this.reader.hasNext()) {
            String name;
            switch (name = this.reader.nextName()) {
                case "value": {
                    value = this.readNullable(this.reader::nextString, "");
                    continue block10;
                }
                case "line": {
                    line = this.reader.nextInt();
                    continue block10;
                }
                case "column": {
                    column = this.reader.nextInt();
                    continue block10;
                }
            }
            this.reader.skipValue();
        }
        this.reader.endObject();
        if (line == -1 || column == -1) {
            throw new JsonParseException("Attributes 'line' and 'column' are mandatory on 'token' object.");
        }
        return new UastNode.Token(line, column, value);
    }

    private Set<UastNode.Kind> readKinds() throws IOException {
        EnumSet<UastNode.Kind> kinds = EnumSet.noneOf(UastNode.Kind.class);
        this.reader.beginArray();
        while (this.reader.hasNext()) {
            String kindAsString = this.reader.nextString();
            UastNode.Kind kind = KIND_MAP.get(kindAsString);
            if (kind == null) continue;
            kinds.add(kind);
        }
        this.reader.endArray();
        return kinds;
    }

    private <T> T readNullable(SupplierEx<T> supplierEx, @Nullable T defaultValue) {
        try {
            if (this.reader.peek() == JsonToken.NULL) {
                this.reader.nextNull();
                return defaultValue;
            }
            return supplierEx.get();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @FunctionalInterface
    static interface SupplierEx<T> {
        public T get() throws IOException;
    }
}

