/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.uast.helpers;

import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.uast.UastNode;

public class ParenthesizedLike {
    private final UastNode node;
    private final UastNode expression;
    private final UastNode leftParenthesis;
    private final UastNode rightParenthesis;

    private ParenthesizedLike(UastNode node, UastNode leftParenthesis, UastNode expression, UastNode rightParenthesis) {
        this.node = node;
        this.leftParenthesis = leftParenthesis;
        this.expression = expression;
        this.rightParenthesis = rightParenthesis;
    }

    @Nullable
    public static ParenthesizedLike from(UastNode node) {
        if (node.is(UastNode.Kind.PARENTHESIZED_EXPRESSION)) {
            Optional<UastNode> leftParenthesis = node.getChild(UastNode.Kind.LEFT_PARENTHESIS);
            Optional<UastNode> expression = node.getChild(UastNode.Kind.EXPRESSION);
            Optional<UastNode> rightParenthesis = node.getChild(UastNode.Kind.RIGHT_PARENTHESIS);
            if (leftParenthesis.isPresent() && expression.isPresent() && rightParenthesis.isPresent()) {
                return new ParenthesizedLike(node, leftParenthesis.get(), expression.get(), rightParenthesis.get());
            }
        }
        return null;
    }

    public UastNode node() {
        return this.node;
    }

    public UastNode expression() {
        return this.expression;
    }

    public UastNode leftParenthesis() {
        return this.leftParenthesis;
    }

    public UastNode rightParenthesis() {
        return this.rightParenthesis;
    }
}

