/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.uast.validators;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.sonar.uast.UastNode;
import org.sonar.uast.Visitor;
import org.sonar.uast.validators.BinaryExpressionValidator;
import org.sonar.uast.validators.CaseValidator;
import org.sonar.uast.validators.DefaultCaseValidator;
import org.sonar.uast.validators.ForValidator;
import org.sonar.uast.validators.IfValidator;
import org.sonar.uast.validators.ParenthesizedExpressionValidator;
import org.sonar.uast.validators.SwitchValidator;

public abstract class Validator
extends Visitor {
    private UastNode node;

    public Validator(UastNode.Kind targetKind) {
        super(targetKind);
    }

    public static List<Validator> all() {
        return Arrays.asList(new SwitchValidator(), new DefaultCaseValidator(), new CaseValidator(), new IfValidator(), new ForValidator(), new BinaryExpressionValidator(), new ParenthesizedExpressionValidator());
    }

    @Override
    public final void visitNode(UastNode node) {
        this.node = node;
        this.validate(node);
    }

    public abstract void validate(UastNode var1);

    private void fail(String errorMessage, Object ... params) {
        UastNode.Token token = this.node.firstToken();
        String line = "N/A";
        if (token != null) {
            line = "" + token.line;
        }
        throw new ValidationException(this.getClass().getSimpleName() + " at line " + line + ": " + String.format(errorMessage, params));
    }

    public void is(UastNode.Kind ... expectedKinds) {
        for (UastNode.Kind expected : expectedKinds) {
            if (!this.node.isNot(expected)) continue;
            this.fail("Expected to have kind '%s' but got %s.", expected.name(), this.node.kinds);
        }
    }

    public void hasKeyword(String keywordValue) {
        Optional<UastNode> keyword = this.node.getChild(UastNode.Kind.KEYWORD);
        if (!keyword.isPresent()) {
            this.fail("No keyword found.", new Object[0]);
        } else {
            UastNode keywordNode = keyword.get();
            if (!keywordValue.equals(keywordNode.token.value)) {
                this.fail("Expected '%s' as keyword but got '%s'.", keywordValue, keywordNode.token.value);
            }
        }
    }

    public void hasAncestor(UastNode.Kind ancestorKind) {
        if (!this.node.getAncestor(ancestorKind).isPresent()) {
            this.fail("Should have a node of kind '%s' as ancestor.", ancestorKind);
        }
    }

    public void oneOrMoreChild(UastNode.Kind kind) {
        if (this.node.getChildren(kind).isEmpty()) {
            this.fail("Should have at least one child of kind '%s'.", kind);
        }
    }

    public void noChild(UastNode.Kind forbiddenKind) {
        if (!this.node.getChildren(forbiddenKind).isEmpty()) {
            this.fail("Should not have any child of kind '%s'.", forbiddenKind);
        }
    }

    public void singleChild(UastNode.Kind kind) {
        List<UastNode> children = this.node.getChildren(kind);
        if (children.isEmpty()) {
            this.fail("Should have one single child of kind '%s' but got none.", kind);
        }
        if (children.size() != 1) {
            this.fail("Should have one single child of kind '%s' but got %s.", kind, children);
        }
    }

    public Optional<UastNode> zeroOrOneChild(UastNode.Kind kind) {
        List<UastNode> children = this.node.getChildren(kind);
        if (children.isEmpty()) {
            return Optional.empty();
        }
        if (children.size() > 1) {
            this.fail("Should have one single child of kind '%s' but got %s.", kind, children);
        }
        return Optional.of(children.get(0));
    }

    public static class ValidationException
    extends RuntimeException {
        public ValidationException(String message) {
            super(message);
        }
    }
}

