/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.utils.Version;

public class InputFileContentExtractor {
    public static final Version V6_0 = Version.create((int)6, (int)0);
    public static final Version V6_2 = Version.create((int)6, (int)2);
    private final SonarQubeAdapter sonarQubeAdapter;

    public InputFileContentExtractor(SensorContext sensorContext) {
        Version version = sensorContext.getSonarQubeVersion();
        this.sonarQubeAdapter = version.isGreaterThanOrEqual(V6_2) ? new SonarQube62Adapter() : (version.isGreaterThanOrEqual(V6_0) ? new SonarQube60Adapter() : new SonarQube56Adapter(sensorContext.fileSystem().encoding()));
    }

    public String content(InputFile inputFile) {
        try {
            return this.sonarQubeAdapter.content(inputFile);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot read content of " + inputFile, e);
        }
    }

    private static String readFile(InputFile inputFile, Charset charset) throws IOException {
        return new String(Files.readAllBytes(inputFile.file().toPath()), charset);
    }

    private static class SonarQube62Adapter
    implements SonarQubeAdapter {
        private SonarQube62Adapter() {
        }

        @Override
        public String content(InputFile inputFile) throws IOException {
            return inputFile.contents();
        }
    }

    private static class SonarQube60Adapter
    implements SonarQubeAdapter {
        private SonarQube60Adapter() {
        }

        @Override
        public String content(InputFile inputFile) throws IOException {
            return InputFileContentExtractor.readFile(inputFile, inputFile.charset());
        }
    }

    private static class SonarQube56Adapter
    implements SonarQubeAdapter {
        private final Charset fileSystemEncoding;

        public SonarQube56Adapter(Charset fileSystemEncoding) {
            this.fileSystemEncoding = fileSystemEncoding;
        }

        @Override
        public String content(InputFile inputFile) throws IOException {
            return InputFileContentExtractor.readFile(inputFile, this.fileSystemEncoding);
        }
    }

    private static interface SonarQubeAdapter {
        public String content(InputFile var1) throws IOException;
    }
}

