/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.ldap;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.apache.commons.lang.math.NumberUtils;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

@ServerSide
public class LdapAutodiscovery {
    private static final Logger LOG = Loggers.get(LdapAutodiscovery.class);

    public static String getDnsDomainName() throws UnknownHostException {
        return LdapAutodiscovery.getDnsDomainName(InetAddress.getLocalHost().getCanonicalHostName());
    }

    public static String getDnsDomainName(String fqdn) {
        if (fqdn.indexOf(46) == -1) {
            return null;
        }
        return fqdn.substring(fqdn.indexOf(46) + 1);
    }

    public static String getDnsDomainDn(String domain) {
        StringBuilder result = new StringBuilder();
        String[] domainPart = domain.split("[.]");
        for (int i = 0; i < domainPart.length; ++i) {
            result.append(i > 0 ? "," : "").append("dc=").append(domainPart[i]);
        }
        return result.toString();
    }

    public List<LdapSrvRecord> getLdapServers(String domain) {
        try {
            return this.getLdapServers(new InitialDirContext(), domain);
        }
        catch (NamingException e) {
            LOG.error("Unable to determine LDAP server(s) from DNS", (Throwable)e);
            return Collections.emptyList();
        }
    }

    List<LdapSrvRecord> getLdapServers(DirContext context, String domain) throws NamingException {
        Attributes lSrvAttrs = context.getAttributes("dns:/_ldap._tcp." + domain, new String[]{"srv"});
        Attribute serversAttribute = lSrvAttrs.get("srv");
        NamingEnumeration<?> lEnum = serversAttribute.getAll();
        TreeSet<LdapSrvRecord> result = new TreeSet<LdapSrvRecord>();
        while (lEnum.hasMore()) {
            String srvRecord = (String)lEnum.next();
            String[] srvData = srvRecord.split(" ");
            int priority = NumberUtils.toInt((String)srvData[0]);
            int weight = NumberUtils.toInt((String)srvData[1]);
            String port = srvData[2];
            String target = srvData[3];
            if (target.endsWith(".")) {
                target = target.substring(0, target.length() - 1);
            }
            String server = "ldap://" + target + ":" + port;
            result.add(new LdapSrvRecord(server, priority, weight));
        }
        return new ArrayList<LdapSrvRecord>(result);
    }

    public static class LdapSrvRecord
    implements Comparable<LdapSrvRecord> {
        private final String serverUrl;
        private final int priority;
        private final int weight;

        public LdapSrvRecord(String serverUrl, int priority, int weight) {
            this.serverUrl = serverUrl;
            this.priority = priority;
            this.weight = weight;
        }

        @Override
        public int compareTo(LdapSrvRecord o) {
            if (this.priority == o.priority) {
                return Integer.valueOf(o.weight).compareTo(this.weight);
            }
            return Integer.valueOf(this.priority).compareTo(o.priority);
        }

        public String getServerUrl() {
            return this.serverUrl;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LdapSrvRecord)) {
                return false;
            }
            return this.serverUrl.equals(((LdapSrvRecord)obj).serverUrl);
        }

        public int hashCode() {
            return this.serverUrl.hashCode();
        }
    }
}

