/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.component;

import javax.annotation.Nullable;
import org.sonar.ce.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.ce.task.projectanalysis.analysis.Branch;
import org.sonar.ce.task.projectanalysis.component.BranchPersister;
import org.sonar.ce.task.projectanalysis.component.TreeRootHolder;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.BranchDto;
import org.sonar.db.component.BranchType;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.protobuf.DbProjectBranches;

public class BranchPersisterImpl
implements BranchPersister {
    private final DbClient dbClient;
    private final TreeRootHolder treeRootHolder;
    private final AnalysisMetadataHolder analysisMetadataHolder;

    public BranchPersisterImpl(DbClient dbClient, TreeRootHolder treeRootHolder, AnalysisMetadataHolder analysisMetadataHolder) {
        this.dbClient = dbClient;
        this.treeRootHolder = treeRootHolder;
        this.analysisMetadataHolder = analysisMetadataHolder;
    }

    @Override
    public void persist(DbSession dbSession) {
        Branch branch = this.analysisMetadataHolder.getBranch();
        String branchUuid = this.treeRootHolder.getRoot().getUuid();
        ComponentDto branchComponentDto = (ComponentDto)this.dbClient.componentDao().selectByUuid(dbSession, branchUuid).orElseThrow(() -> new IllegalStateException("Component has been deleted by end-user during analysis"));
        this.dbClient.branchDao().upsert(dbSession, this.toBranchDto(branchComponentDto, branch));
    }

    protected BranchDto toBranchDto(ComponentDto componentDto, Branch branch) {
        BranchDto dto = new BranchDto();
        dto.setUuid(componentDto.uuid());
        dto.setProjectUuid(BranchPersisterImpl.firstNonNull(componentDto.getMainBranchProjectUuid(), componentDto.projectUuid()));
        dto.setBranchType(branch.getType());
        dto.setMergeBranchUuid((String)branch.getMergeBranchUuid().orElse(null));
        if (branch.getType() == BranchType.PULL_REQUEST) {
            dto.setKey(this.analysisMetadataHolder.getPullRequestKey());
            DbProjectBranches.PullRequestData pullRequestData = DbProjectBranches.PullRequestData.newBuilder().setBranch(branch.getName()).setTitle(branch.getName()).build();
            dto.setPullRequestData(pullRequestData);
        } else {
            dto.setKey(branch.getName());
        }
        return dto;
    }

    private static <T> T firstNonNull(@Nullable T first, T second) {
        return first != null ? first : second;
    }
}

