/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.component;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckForNull;
import org.sonar.ce.task.projectanalysis.analysis.AnalysisMetadataHolder;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.BranchDto;
import org.sonar.db.component.ComponentDto;

public class MergeBranchComponentUuids {
    private final AnalysisMetadataHolder analysisMetadataHolder;
    private final DbClient dbClient;
    private Map<String, String> uuidsByKey;
    private String mergeBranchName;
    private boolean hasMergeBranchAnalysis;

    public MergeBranchComponentUuids(AnalysisMetadataHolder analysisMetadataHolder, DbClient dbClient) {
        this.analysisMetadataHolder = analysisMetadataHolder;
        this.dbClient = dbClient;
    }

    private void lazyInit() {
        if (this.uuidsByKey == null) {
            String mergeBranchUuid = this.analysisMetadataHolder.getBranch().getMergeBranchUuid().get();
            this.uuidsByKey = new HashMap<String, String>();
            try (DbSession dbSession = this.dbClient.openSession(false);){
                List components = this.dbClient.componentDao().selectByProjectUuid(mergeBranchUuid, dbSession);
                for (ComponentDto dto : components) {
                    this.uuidsByKey.put(dto.getKey(), dto.uuid());
                }
                Optional opt = this.dbClient.branchDao().selectByUuid(dbSession, mergeBranchUuid);
                Preconditions.checkState((boolean)opt.isPresent(), (String)"Merge branch '%s' does not exist", (Object[])new Object[]{mergeBranchUuid});
                this.mergeBranchName = ((BranchDto)opt.get()).getKey();
                this.hasMergeBranchAnalysis = this.dbClient.snapshotDao().selectLastAnalysisByRootComponentUuid(dbSession, mergeBranchUuid).isPresent();
            }
        }
    }

    public boolean hasMergeBranchAnalysis() {
        this.lazyInit();
        return this.hasMergeBranchAnalysis;
    }

    public String getMergeBranchName() {
        this.lazyInit();
        return this.mergeBranchName;
    }

    @CheckForNull
    public String getUuid(String dbKey) {
        this.lazyInit();
        String cleanComponentKey = ComponentDto.removeBranchAndPullRequestFromKey((String)dbKey);
        return this.uuidsByKey.get(cleanComponentKey);
    }
}

