/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.component;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class ProjectAttributes {
    private final String projectVersion;
    @Nullable
    private final String buildString;

    public ProjectAttributes(String projectVersion, @Nullable String buildString) {
        this.projectVersion = Objects.requireNonNull(projectVersion, "project version can't be null");
        this.buildString = buildString;
    }

    public ProjectAttributes(ProjectAttributes projectAttributes) {
        this.projectVersion = projectAttributes.projectVersion;
        this.buildString = projectAttributes.buildString;
    }

    public String getProjectVersion() {
        return this.projectVersion;
    }

    public Optional<String> getBuildString() {
        return Optional.ofNullable(this.buildString);
    }

    public String toString() {
        return "ProjectAttributes{projectVersion='" + this.projectVersion + '\'' + "buildString='" + this.buildString + '\'' + '}';
    }
}

