/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.task.projectanalysis.dbmigration;

import com.google.common.collect.Iterables;
import java.sql.SQLException;
import org.sonar.ce.task.CeTask;
import org.sonar.ce.task.projectanalysis.dbmigration.ProjectAnalysisDataChange;
import org.sonar.db.Database;
import org.sonar.db.source.FileSourceDto;
import org.sonar.server.platform.db.migration.step.DataChange;
import org.sonar.server.platform.db.migration.step.MassUpdate;
import org.sonar.server.platform.db.migration.step.Select;
import org.sonar.server.platform.db.migration.step.SqlStatement;

public class PopulateFileSourceLineCount
extends DataChange
implements ProjectAnalysisDataChange {
    private final CeTask ceTask;

    public PopulateFileSourceLineCount(Database database, CeTask ceTask) {
        super(database);
        this.ceTask = ceTask;
    }

    protected void execute(DataChange.Context context) throws SQLException {
        String componentUuid = ((CeTask.Component)this.ceTask.getComponent().get()).getUuid();
        Long unInitializedFileSources = (Long)((Select)((Select)context.prepareSelect("select count(1) from file_sources where line_count = ? and project_uuid = ?").setInt(1, Integer.valueOf(-1))).setString(2, componentUuid)).get(row -> row.getLong(1));
        if (unInitializedFileSources != null && unInitializedFileSources > 0L) {
            MassUpdate massUpdate = context.prepareMassUpdate();
            massUpdate.select("select id,line_hashes from file_sources where line_count = ? and project_uuid = ?").setInt(1, Integer.valueOf(-1)).setString(2, componentUuid);
            massUpdate.update("update file_sources set line_count = ? where id = ?");
            massUpdate.rowPluralName("line counts of sources of project " + componentUuid);
            massUpdate.execute(PopulateFileSourceLineCount::handle);
        }
    }

    private static boolean handle(Select.Row row, SqlStatement update) throws SQLException {
        int rowId = row.getInt(1);
        String rawData = row.getNullableString(2);
        int lineCount = rawData == null ? 0 : Iterables.size((Iterable)FileSourceDto.LINES_HASHES_SPLITTER.split((CharSequence)rawData));
        update.setInt(1, Integer.valueOf(lineCount));
        update.setInt(2, Integer.valueOf(rowId));
        return true;
    }
}

